package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ListenerAddressBuilder extends ListenerAddressFluent<ListenerAddressBuilder> implements VisitableBuilder<ListenerAddress,ListenerAddressBuilder>{
  public ListenerAddressBuilder() {
    this(new ListenerAddress());
  }
  
  public ListenerAddressBuilder(ListenerAddressFluent<?> fluent) {
    this(fluent, new ListenerAddress());
  }
  
  public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,ListenerAddress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ListenerAddressBuilder(ListenerAddress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ListenerAddressFluent<?> fluent;
  
  public ListenerAddress build() {
    ListenerAddress buildable = new ListenerAddress();
    buildable.setHost(fluent.getHost());
    buildable.setPort(fluent.getPort());
    return buildable;
  }
  

}