package io.strimzi.api.kafka.model.kafka.listener;

import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.common.GenericSecretSourceFluent;
import java.lang.Integer;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSourceFluent;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.CertSecretSource;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaListenerAuthenticationOAuthFluent<A extends KafkaListenerAuthenticationOAuthFluent<A>> extends KafkaListenerAuthenticationFluent<A>{
  public KafkaListenerAuthenticationOAuthFluent() {
  }
  
  public KafkaListenerAuthenticationOAuthFluent(KafkaListenerAuthenticationOAuth instance) {
    this.copyInstance(instance);
  }
  private String clientId;
  private GenericSecretSourceBuilder clientSecret;
  private String validIssuerUri;
  private boolean checkIssuer;
  private boolean checkAudience;
  private String jwksEndpointUri;
  private Integer jwksRefreshSeconds;
  private Integer jwksMinRefreshPauseSeconds;
  private Integer jwksExpirySeconds;
  private boolean jwksIgnoreKeyUse;
  private String introspectionEndpointUri;
  private String serverBearerTokenLocation;
  private String userNameClaim;
  private String userNamePrefix;
  private String fallbackUserNameClaim;
  private String fallbackUserNamePrefix;
  private String groupsClaim;
  private String groupsClaimDelimiter;
  private String userInfoEndpointUri;
  private boolean checkAccessTokenType;
  private String validTokenType;
  private boolean accessTokenIsJwt;
  private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
  private boolean disableTlsHostnameVerification;
  private Boolean enableECDSA;
  private Integer maxSecondsWithoutReauthentication;
  private boolean enablePlain;
  private String tokenEndpointUri;
  private boolean enableOauthBearer;
  private String customClaimCheck;
  private Integer connectTimeoutSeconds;
  private Integer readTimeoutSeconds;
  private Integer httpRetries;
  private Integer httpRetryPauseMs;
  private String clientScope;
  private String clientAudience;
  private boolean enableMetrics;
  private boolean failFast;
  private boolean includeAcceptHeader;
  
  protected void copyInstance(KafkaListenerAuthenticationOAuth instance) {
    instance = (instance != null ? instance : new KafkaListenerAuthenticationOAuth());
    if (instance != null) {
          this.withClientId(instance.getClientId());
          this.withClientSecret(instance.getClientSecret());
          this.withValidIssuerUri(instance.getValidIssuerUri());
          this.withCheckIssuer(instance.isCheckIssuer());
          this.withCheckAudience(instance.isCheckAudience());
          this.withJwksEndpointUri(instance.getJwksEndpointUri());
          this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
          this.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
          this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
          this.withJwksIgnoreKeyUse(instance.getJwksIgnoreKeyUse());
          this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
          this.withServerBearerTokenLocation(instance.getServerBearerTokenLocation());
          this.withUserNameClaim(instance.getUserNameClaim());
          this.withUserNamePrefix(instance.getUserNamePrefix());
          this.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
          this.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
          this.withGroupsClaim(instance.getGroupsClaim());
          this.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
          this.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
          this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
          this.withValidTokenType(instance.getValidTokenType());
          this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
          this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
          this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
          this.withEnableECDSA(instance.getEnableECDSA());
          this.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
          this.withEnablePlain(instance.isEnablePlain());
          this.withTokenEndpointUri(instance.getTokenEndpointUri());
          this.withEnableOauthBearer(instance.isEnableOauthBearer());
          this.withCustomClaimCheck(instance.getCustomClaimCheck());
          this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
          this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
          this.withHttpRetries(instance.getHttpRetries());
          this.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
          this.withClientScope(instance.getClientScope());
          this.withClientAudience(instance.getClientAudience());
          this.withEnableMetrics(instance.isEnableMetrics());
          this.withFailFast(instance.getFailFast());
          this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
        }
  }
  
  public String getClientId() {
    return this.clientId;
  }
  
  public A withClientId(String clientId) {
    this.clientId = clientId;
    return (A) this;
  }
  
  public boolean hasClientId() {
    return this.clientId != null;
  }
  
  public GenericSecretSource buildClientSecret() {
    return this.clientSecret != null ? this.clientSecret.build() : null;
  }
  
  public A withClientSecret(GenericSecretSource clientSecret) {
    this._visitables.remove("clientSecret");
    if (clientSecret != null) {
        this.clientSecret = new GenericSecretSourceBuilder(clientSecret);
        this._visitables.get("clientSecret").add(this.clientSecret);
    } else {
        this.clientSecret = null;
        this._visitables.get("clientSecret").remove(this.clientSecret);
    }
    return (A) this;
  }
  
  public boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  
  public ClientSecretNested<A> withNewClientSecret() {
    return new ClientSecretNested(null);
  }
  
  public ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
    return new ClientSecretNested(item);
  }
  
  public ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(null));
  }
  
  public ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(new GenericSecretSourceBuilder().build()));
  }
  
  public ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
    return withNewClientSecretLike(java.util.Optional.ofNullable(buildClientSecret()).orElse(item));
  }
  
  public String getValidIssuerUri() {
    return this.validIssuerUri;
  }
  
  public A withValidIssuerUri(String validIssuerUri) {
    this.validIssuerUri = validIssuerUri;
    return (A) this;
  }
  
  public boolean hasValidIssuerUri() {
    return this.validIssuerUri != null;
  }
  
  public boolean isCheckIssuer() {
    return this.checkIssuer;
  }
  
  public A withCheckIssuer(boolean checkIssuer) {
    this.checkIssuer = checkIssuer;
    return (A) this;
  }
  
  public boolean hasCheckIssuer() {
    return true;
  }
  
  public boolean isCheckAudience() {
    return this.checkAudience;
  }
  
  public A withCheckAudience(boolean checkAudience) {
    this.checkAudience = checkAudience;
    return (A) this;
  }
  
  public boolean hasCheckAudience() {
    return true;
  }
  
  public String getJwksEndpointUri() {
    return this.jwksEndpointUri;
  }
  
  public A withJwksEndpointUri(String jwksEndpointUri) {
    this.jwksEndpointUri = jwksEndpointUri;
    return (A) this;
  }
  
  public boolean hasJwksEndpointUri() {
    return this.jwksEndpointUri != null;
  }
  
  public Integer getJwksRefreshSeconds() {
    return this.jwksRefreshSeconds;
  }
  
  public A withJwksRefreshSeconds(Integer jwksRefreshSeconds) {
    this.jwksRefreshSeconds = jwksRefreshSeconds;
    return (A) this;
  }
  
  public boolean hasJwksRefreshSeconds() {
    return this.jwksRefreshSeconds != null;
  }
  
  public Integer getJwksMinRefreshPauseSeconds() {
    return this.jwksMinRefreshPauseSeconds;
  }
  
  public A withJwksMinRefreshPauseSeconds(Integer jwksMinRefreshPauseSeconds) {
    this.jwksMinRefreshPauseSeconds = jwksMinRefreshPauseSeconds;
    return (A) this;
  }
  
  public boolean hasJwksMinRefreshPauseSeconds() {
    return this.jwksMinRefreshPauseSeconds != null;
  }
  
  public Integer getJwksExpirySeconds() {
    return this.jwksExpirySeconds;
  }
  
  public A withJwksExpirySeconds(Integer jwksExpirySeconds) {
    this.jwksExpirySeconds = jwksExpirySeconds;
    return (A) this;
  }
  
  public boolean hasJwksExpirySeconds() {
    return this.jwksExpirySeconds != null;
  }
  
  public boolean isJwksIgnoreKeyUse() {
    return this.jwksIgnoreKeyUse;
  }
  
  public A withJwksIgnoreKeyUse(boolean jwksIgnoreKeyUse) {
    this.jwksIgnoreKeyUse = jwksIgnoreKeyUse;
    return (A) this;
  }
  
  public boolean hasJwksIgnoreKeyUse() {
    return true;
  }
  
  public String getIntrospectionEndpointUri() {
    return this.introspectionEndpointUri;
  }
  
  public A withIntrospectionEndpointUri(String introspectionEndpointUri) {
    this.introspectionEndpointUri = introspectionEndpointUri;
    return (A) this;
  }
  
  public boolean hasIntrospectionEndpointUri() {
    return this.introspectionEndpointUri != null;
  }
  
  public String getServerBearerTokenLocation() {
    return this.serverBearerTokenLocation;
  }
  
  public A withServerBearerTokenLocation(String serverBearerTokenLocation) {
    this.serverBearerTokenLocation = serverBearerTokenLocation;
    return (A) this;
  }
  
  public boolean hasServerBearerTokenLocation() {
    return this.serverBearerTokenLocation != null;
  }
  
  public String getUserNameClaim() {
    return this.userNameClaim;
  }
  
  public A withUserNameClaim(String userNameClaim) {
    this.userNameClaim = userNameClaim;
    return (A) this;
  }
  
  public boolean hasUserNameClaim() {
    return this.userNameClaim != null;
  }
  
  public String getUserNamePrefix() {
    return this.userNamePrefix;
  }
  
  public A withUserNamePrefix(String userNamePrefix) {
    this.userNamePrefix = userNamePrefix;
    return (A) this;
  }
  
  public boolean hasUserNamePrefix() {
    return this.userNamePrefix != null;
  }
  
  public String getFallbackUserNameClaim() {
    return this.fallbackUserNameClaim;
  }
  
  public A withFallbackUserNameClaim(String fallbackUserNameClaim) {
    this.fallbackUserNameClaim = fallbackUserNameClaim;
    return (A) this;
  }
  
  public boolean hasFallbackUserNameClaim() {
    return this.fallbackUserNameClaim != null;
  }
  
  public String getFallbackUserNamePrefix() {
    return this.fallbackUserNamePrefix;
  }
  
  public A withFallbackUserNamePrefix(String fallbackUserNamePrefix) {
    this.fallbackUserNamePrefix = fallbackUserNamePrefix;
    return (A) this;
  }
  
  public boolean hasFallbackUserNamePrefix() {
    return this.fallbackUserNamePrefix != null;
  }
  
  public String getGroupsClaim() {
    return this.groupsClaim;
  }
  
  public A withGroupsClaim(String groupsClaim) {
    this.groupsClaim = groupsClaim;
    return (A) this;
  }
  
  public boolean hasGroupsClaim() {
    return this.groupsClaim != null;
  }
  
  public String getGroupsClaimDelimiter() {
    return this.groupsClaimDelimiter;
  }
  
  public A withGroupsClaimDelimiter(String groupsClaimDelimiter) {
    this.groupsClaimDelimiter = groupsClaimDelimiter;
    return (A) this;
  }
  
  public boolean hasGroupsClaimDelimiter() {
    return this.groupsClaimDelimiter != null;
  }
  
  public String getUserInfoEndpointUri() {
    return this.userInfoEndpointUri;
  }
  
  public A withUserInfoEndpointUri(String userInfoEndpointUri) {
    this.userInfoEndpointUri = userInfoEndpointUri;
    return (A) this;
  }
  
  public boolean hasUserInfoEndpointUri() {
    return this.userInfoEndpointUri != null;
  }
  
  public boolean isCheckAccessTokenType() {
    return this.checkAccessTokenType;
  }
  
  public A withCheckAccessTokenType(boolean checkAccessTokenType) {
    this.checkAccessTokenType = checkAccessTokenType;
    return (A) this;
  }
  
  public boolean hasCheckAccessTokenType() {
    return true;
  }
  
  public String getValidTokenType() {
    return this.validTokenType;
  }
  
  public A withValidTokenType(String validTokenType) {
    this.validTokenType = validTokenType;
    return (A) this;
  }
  
  public boolean hasValidTokenType() {
    return this.validTokenType != null;
  }
  
  public boolean isAccessTokenIsJwt() {
    return this.accessTokenIsJwt;
  }
  
  public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
    this.accessTokenIsJwt = accessTokenIsJwt;
    return (A) this;
  }
  
  public boolean hasAccessTokenIsJwt() {
    return true;
  }
  
  public A addToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").add(index, builder); tlsTrustedCertificates.add(index, builder);}
    return (A)this;
  }
  
  public A setToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder); tlsTrustedCertificates.set(index, builder);}
    return (A)this;
  }
  
  public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  
  public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  
  public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
    if (tlsTrustedCertificates == null) return (A) this;
    final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
    final List visitables = _visitables.get("tlsTrustedCertificates");
    while (each.hasNext()) {
      CertSecretSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CertSecretSource> buildTlsTrustedCertificates() {
    return this.tlsTrustedCertificates != null ? build(tlsTrustedCertificates) : null;
  }
  
  public CertSecretSource buildTlsTrustedCertificate(int index) {
    return this.tlsTrustedCertificates.get(index).build();
  }
  
  public CertSecretSource buildFirstTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(0).build();
  }
  
  public CertSecretSource buildLastTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
  }
  
  public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
      for (CertSecretSourceBuilder item : tlsTrustedCertificates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
      for (CertSecretSourceBuilder item : tlsTrustedCertificates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) {
      this._visitables.get("tlsTrustedCertificates").clear();
    }
    if (tlsTrustedCertificates != null) {
        this.tlsTrustedCertificates = new ArrayList();
        for (CertSecretSource item : tlsTrustedCertificates) {
          this.addToTlsTrustedCertificates(item);
        }
    } else {
      this.tlsTrustedCertificates = null;
    }
    return (A) this;
  }
  
  public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) {
        this.tlsTrustedCertificates.clear();
        _visitables.remove("tlsTrustedCertificates");
    }
    if (tlsTrustedCertificates != null) {
      for (CertSecretSource item : tlsTrustedCertificates) {
        this.addToTlsTrustedCertificates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTlsTrustedCertificates() {
    return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
  }
  
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
    return new TlsTrustedCertificatesNested(-1, null);
  }
  
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
    return new TlsTrustedCertificatesNested(-1, item);
  }
  
  public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item) {
    return new TlsTrustedCertificatesNested(index, item);
  }
  
  public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
    if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  
  public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
    if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
  }
  
  public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
    int index = tlsTrustedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  
  public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tlsTrustedCertificates.size();i++) { 
    if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  
  public boolean isDisableTlsHostnameVerification() {
    return this.disableTlsHostnameVerification;
  }
  
  public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
    this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    return (A) this;
  }
  
  public boolean hasDisableTlsHostnameVerification() {
    return true;
  }
  
  public Boolean getEnableECDSA() {
    return this.enableECDSA;
  }
  
  public A withEnableECDSA(Boolean enableECDSA) {
    this.enableECDSA = enableECDSA;
    return (A) this;
  }
  
  public boolean hasEnableECDSA() {
    return this.enableECDSA != null;
  }
  
  public Integer getMaxSecondsWithoutReauthentication() {
    return this.maxSecondsWithoutReauthentication;
  }
  
  public A withMaxSecondsWithoutReauthentication(Integer maxSecondsWithoutReauthentication) {
    this.maxSecondsWithoutReauthentication = maxSecondsWithoutReauthentication;
    return (A) this;
  }
  
  public boolean hasMaxSecondsWithoutReauthentication() {
    return this.maxSecondsWithoutReauthentication != null;
  }
  
  public boolean isEnablePlain() {
    return this.enablePlain;
  }
  
  public A withEnablePlain(boolean enablePlain) {
    this.enablePlain = enablePlain;
    return (A) this;
  }
  
  public boolean hasEnablePlain() {
    return true;
  }
  
  public String getTokenEndpointUri() {
    return this.tokenEndpointUri;
  }
  
  public A withTokenEndpointUri(String tokenEndpointUri) {
    this.tokenEndpointUri = tokenEndpointUri;
    return (A) this;
  }
  
  public boolean hasTokenEndpointUri() {
    return this.tokenEndpointUri != null;
  }
  
  public boolean isEnableOauthBearer() {
    return this.enableOauthBearer;
  }
  
  public A withEnableOauthBearer(boolean enableOauthBearer) {
    this.enableOauthBearer = enableOauthBearer;
    return (A) this;
  }
  
  public boolean hasEnableOauthBearer() {
    return true;
  }
  
  public String getCustomClaimCheck() {
    return this.customClaimCheck;
  }
  
  public A withCustomClaimCheck(String customClaimCheck) {
    this.customClaimCheck = customClaimCheck;
    return (A) this;
  }
  
  public boolean hasCustomClaimCheck() {
    return this.customClaimCheck != null;
  }
  
  public Integer getConnectTimeoutSeconds() {
    return this.connectTimeoutSeconds;
  }
  
  public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
    this.connectTimeoutSeconds = connectTimeoutSeconds;
    return (A) this;
  }
  
  public boolean hasConnectTimeoutSeconds() {
    return this.connectTimeoutSeconds != null;
  }
  
  public Integer getReadTimeoutSeconds() {
    return this.readTimeoutSeconds;
  }
  
  public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
    this.readTimeoutSeconds = readTimeoutSeconds;
    return (A) this;
  }
  
  public boolean hasReadTimeoutSeconds() {
    return this.readTimeoutSeconds != null;
  }
  
  public Integer getHttpRetries() {
    return this.httpRetries;
  }
  
  public A withHttpRetries(Integer httpRetries) {
    this.httpRetries = httpRetries;
    return (A) this;
  }
  
  public boolean hasHttpRetries() {
    return this.httpRetries != null;
  }
  
  public Integer getHttpRetryPauseMs() {
    return this.httpRetryPauseMs;
  }
  
  public A withHttpRetryPauseMs(Integer httpRetryPauseMs) {
    this.httpRetryPauseMs = httpRetryPauseMs;
    return (A) this;
  }
  
  public boolean hasHttpRetryPauseMs() {
    return this.httpRetryPauseMs != null;
  }
  
  public String getClientScope() {
    return this.clientScope;
  }
  
  public A withClientScope(String clientScope) {
    this.clientScope = clientScope;
    return (A) this;
  }
  
  public boolean hasClientScope() {
    return this.clientScope != null;
  }
  
  public String getClientAudience() {
    return this.clientAudience;
  }
  
  public A withClientAudience(String clientAudience) {
    this.clientAudience = clientAudience;
    return (A) this;
  }
  
  public boolean hasClientAudience() {
    return this.clientAudience != null;
  }
  
  public boolean isEnableMetrics() {
    return this.enableMetrics;
  }
  
  public A withEnableMetrics(boolean enableMetrics) {
    this.enableMetrics = enableMetrics;
    return (A) this;
  }
  
  public boolean hasEnableMetrics() {
    return true;
  }
  
  public boolean isFailFast() {
    return this.failFast;
  }
  
  public A withFailFast(boolean failFast) {
    this.failFast = failFast;
    return (A) this;
  }
  
  public boolean hasFailFast() {
    return true;
  }
  
  public boolean isIncludeAcceptHeader() {
    return this.includeAcceptHeader;
  }
  
  public A withIncludeAcceptHeader(boolean includeAcceptHeader) {
    this.includeAcceptHeader = includeAcceptHeader;
    return (A) this;
  }
  
  public boolean hasIncludeAcceptHeader() {
    return true;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaListenerAuthenticationOAuthFluent that = (KafkaListenerAuthenticationOAuthFluent) o;
    if (!java.util.Objects.equals(clientId, that.clientId)) return false;
    if (!java.util.Objects.equals(clientSecret, that.clientSecret)) return false;
    if (!java.util.Objects.equals(validIssuerUri, that.validIssuerUri)) return false;
    if (checkIssuer != that.checkIssuer) return false;
    if (checkAudience != that.checkAudience) return false;
    if (!java.util.Objects.equals(jwksEndpointUri, that.jwksEndpointUri)) return false;
    if (!java.util.Objects.equals(jwksRefreshSeconds, that.jwksRefreshSeconds)) return false;
    if (!java.util.Objects.equals(jwksMinRefreshPauseSeconds, that.jwksMinRefreshPauseSeconds)) return false;
    if (!java.util.Objects.equals(jwksExpirySeconds, that.jwksExpirySeconds)) return false;
    if (jwksIgnoreKeyUse != that.jwksIgnoreKeyUse) return false;
    if (!java.util.Objects.equals(introspectionEndpointUri, that.introspectionEndpointUri)) return false;
    if (!java.util.Objects.equals(serverBearerTokenLocation, that.serverBearerTokenLocation)) return false;
    if (!java.util.Objects.equals(userNameClaim, that.userNameClaim)) return false;
    if (!java.util.Objects.equals(userNamePrefix, that.userNamePrefix)) return false;
    if (!java.util.Objects.equals(fallbackUserNameClaim, that.fallbackUserNameClaim)) return false;
    if (!java.util.Objects.equals(fallbackUserNamePrefix, that.fallbackUserNamePrefix)) return false;
    if (!java.util.Objects.equals(groupsClaim, that.groupsClaim)) return false;
    if (!java.util.Objects.equals(groupsClaimDelimiter, that.groupsClaimDelimiter)) return false;
    if (!java.util.Objects.equals(userInfoEndpointUri, that.userInfoEndpointUri)) return false;
    if (checkAccessTokenType != that.checkAccessTokenType) return false;
    if (!java.util.Objects.equals(validTokenType, that.validTokenType)) return false;
    if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
    if (!java.util.Objects.equals(tlsTrustedCertificates, that.tlsTrustedCertificates)) return false;
    if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
    if (!java.util.Objects.equals(enableECDSA, that.enableECDSA)) return false;
    if (!java.util.Objects.equals(maxSecondsWithoutReauthentication, that.maxSecondsWithoutReauthentication)) return false;
    if (enablePlain != that.enablePlain) return false;
    if (!java.util.Objects.equals(tokenEndpointUri, that.tokenEndpointUri)) return false;
    if (enableOauthBearer != that.enableOauthBearer) return false;
    if (!java.util.Objects.equals(customClaimCheck, that.customClaimCheck)) return false;
    if (!java.util.Objects.equals(connectTimeoutSeconds, that.connectTimeoutSeconds)) return false;
    if (!java.util.Objects.equals(readTimeoutSeconds, that.readTimeoutSeconds)) return false;
    if (!java.util.Objects.equals(httpRetries, that.httpRetries)) return false;
    if (!java.util.Objects.equals(httpRetryPauseMs, that.httpRetryPauseMs)) return false;
    if (!java.util.Objects.equals(clientScope, that.clientScope)) return false;
    if (!java.util.Objects.equals(clientAudience, that.clientAudience)) return false;
    if (enableMetrics != that.enableMetrics) return false;
    if (failFast != that.failFast) return false;
    if (includeAcceptHeader != that.includeAcceptHeader) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientId,  clientSecret,  validIssuerUri,  checkIssuer,  checkAudience,  jwksEndpointUri,  jwksRefreshSeconds,  jwksMinRefreshPauseSeconds,  jwksExpirySeconds,  jwksIgnoreKeyUse,  introspectionEndpointUri,  serverBearerTokenLocation,  userNameClaim,  userNamePrefix,  fallbackUserNameClaim,  fallbackUserNamePrefix,  groupsClaim,  groupsClaimDelimiter,  userInfoEndpointUri,  checkAccessTokenType,  validTokenType,  accessTokenIsJwt,  tlsTrustedCertificates,  disableTlsHostnameVerification,  enableECDSA,  maxSecondsWithoutReauthentication,  enablePlain,  tokenEndpointUri,  enableOauthBearer,  customClaimCheck,  connectTimeoutSeconds,  readTimeoutSeconds,  httpRetries,  httpRetryPauseMs,  clientScope,  clientAudience,  enableMetrics,  failFast,  includeAcceptHeader,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientId != null) { sb.append("clientId:"); sb.append(clientId + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (validIssuerUri != null) { sb.append("validIssuerUri:"); sb.append(validIssuerUri + ","); }
    sb.append("checkIssuer:"); sb.append(checkIssuer + ",");
    sb.append("checkAudience:"); sb.append(checkAudience + ",");
    if (jwksEndpointUri != null) { sb.append("jwksEndpointUri:"); sb.append(jwksEndpointUri + ","); }
    if (jwksRefreshSeconds != null) { sb.append("jwksRefreshSeconds:"); sb.append(jwksRefreshSeconds + ","); }
    if (jwksMinRefreshPauseSeconds != null) { sb.append("jwksMinRefreshPauseSeconds:"); sb.append(jwksMinRefreshPauseSeconds + ","); }
    if (jwksExpirySeconds != null) { sb.append("jwksExpirySeconds:"); sb.append(jwksExpirySeconds + ","); }
    sb.append("jwksIgnoreKeyUse:"); sb.append(jwksIgnoreKeyUse + ",");
    if (introspectionEndpointUri != null) { sb.append("introspectionEndpointUri:"); sb.append(introspectionEndpointUri + ","); }
    if (serverBearerTokenLocation != null) { sb.append("serverBearerTokenLocation:"); sb.append(serverBearerTokenLocation + ","); }
    if (userNameClaim != null) { sb.append("userNameClaim:"); sb.append(userNameClaim + ","); }
    if (userNamePrefix != null) { sb.append("userNamePrefix:"); sb.append(userNamePrefix + ","); }
    if (fallbackUserNameClaim != null) { sb.append("fallbackUserNameClaim:"); sb.append(fallbackUserNameClaim + ","); }
    if (fallbackUserNamePrefix != null) { sb.append("fallbackUserNamePrefix:"); sb.append(fallbackUserNamePrefix + ","); }
    if (groupsClaim != null) { sb.append("groupsClaim:"); sb.append(groupsClaim + ","); }
    if (groupsClaimDelimiter != null) { sb.append("groupsClaimDelimiter:"); sb.append(groupsClaimDelimiter + ","); }
    if (userInfoEndpointUri != null) { sb.append("userInfoEndpointUri:"); sb.append(userInfoEndpointUri + ","); }
    sb.append("checkAccessTokenType:"); sb.append(checkAccessTokenType + ",");
    if (validTokenType != null) { sb.append("validTokenType:"); sb.append(validTokenType + ","); }
    sb.append("accessTokenIsJwt:"); sb.append(accessTokenIsJwt + ",");
    if (tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty()) { sb.append("tlsTrustedCertificates:"); sb.append(tlsTrustedCertificates + ","); }
    sb.append("disableTlsHostnameVerification:"); sb.append(disableTlsHostnameVerification + ",");
    if (enableECDSA != null) { sb.append("enableECDSA:"); sb.append(enableECDSA + ","); }
    if (maxSecondsWithoutReauthentication != null) { sb.append("maxSecondsWithoutReauthentication:"); sb.append(maxSecondsWithoutReauthentication + ","); }
    sb.append("enablePlain:"); sb.append(enablePlain + ",");
    if (tokenEndpointUri != null) { sb.append("tokenEndpointUri:"); sb.append(tokenEndpointUri + ","); }
    sb.append("enableOauthBearer:"); sb.append(enableOauthBearer + ",");
    if (customClaimCheck != null) { sb.append("customClaimCheck:"); sb.append(customClaimCheck + ","); }
    if (connectTimeoutSeconds != null) { sb.append("connectTimeoutSeconds:"); sb.append(connectTimeoutSeconds + ","); }
    if (readTimeoutSeconds != null) { sb.append("readTimeoutSeconds:"); sb.append(readTimeoutSeconds + ","); }
    if (httpRetries != null) { sb.append("httpRetries:"); sb.append(httpRetries + ","); }
    if (httpRetryPauseMs != null) { sb.append("httpRetryPauseMs:"); sb.append(httpRetryPauseMs + ","); }
    if (clientScope != null) { sb.append("clientScope:"); sb.append(clientScope + ","); }
    if (clientAudience != null) { sb.append("clientAudience:"); sb.append(clientAudience + ","); }
    sb.append("enableMetrics:"); sb.append(enableMetrics + ",");
    sb.append("failFast:"); sb.append(failFast + ",");
    sb.append("includeAcceptHeader:"); sb.append(includeAcceptHeader);
    sb.append("}");
    return sb.toString();
  }
  
  public A withCheckIssuer() {
    return withCheckIssuer(true);
  }
  
  public A withCheckAudience() {
    return withCheckAudience(true);
  }
  
  public A withJwksIgnoreKeyUse() {
    return withJwksIgnoreKeyUse(true);
  }
  
  public A withCheckAccessTokenType() {
    return withCheckAccessTokenType(true);
  }
  
  public A withAccessTokenIsJwt() {
    return withAccessTokenIsJwt(true);
  }
  
  public A withDisableTlsHostnameVerification() {
    return withDisableTlsHostnameVerification(true);
  }
  
  public A withEnableECDSA() {
    return withEnableECDSA(true);
  }
  
  public A withEnablePlain() {
    return withEnablePlain(true);
  }
  
  public A withEnableOauthBearer() {
    return withEnableOauthBearer(true);
  }
  
  public A withEnableMetrics() {
    return withEnableMetrics(true);
  }
  
  public A withFailFast() {
    return withFailFast(true);
  }
  
  public A withIncludeAcceptHeader() {
    return withIncludeAcceptHeader(true);
  }
  public class ClientSecretNested<N> extends GenericSecretSourceFluent<ClientSecretNested<N>> implements Nested<N>{
    ClientSecretNested(GenericSecretSource item) {
      this.builder = new GenericSecretSourceBuilder(this, item);
    }
    GenericSecretSourceBuilder builder;
    
    public N and() {
      return (N) KafkaListenerAuthenticationOAuthFluent.this.withClientSecret(builder.build());
    }
    
    public N endClientSecret() {
      return and();
    }
    
  
  }
  public class TlsTrustedCertificatesNested<N> extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>> implements Nested<N>{
    TlsTrustedCertificatesNested(int index,CertSecretSource item) {
      this.index = index;
      this.builder = new CertSecretSourceBuilder(this, item);
    }
    CertSecretSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaListenerAuthenticationOAuthFluent.this.setToTlsTrustedCertificates(index,builder.build());
    }
    
    public N endTlsTrustedCertificate() {
      return and();
    }
    
  
  }

}