package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaListenerAuthenticationOAuthBuilder extends KafkaListenerAuthenticationOAuthFluent<KafkaListenerAuthenticationOAuthBuilder> implements VisitableBuilder<KafkaListenerAuthenticationOAuth,KafkaListenerAuthenticationOAuthBuilder>{
  public KafkaListenerAuthenticationOAuthBuilder() {
    this(new KafkaListenerAuthenticationOAuth());
  }
  
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent) {
    this(fluent, new KafkaListenerAuthenticationOAuth());
  }
  
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuthFluent<?> fluent,KafkaListenerAuthenticationOAuth instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaListenerAuthenticationOAuthBuilder(KafkaListenerAuthenticationOAuth instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaListenerAuthenticationOAuthFluent<?> fluent;
  
  public KafkaListenerAuthenticationOAuth build() {
    KafkaListenerAuthenticationOAuth buildable = new KafkaListenerAuthenticationOAuth();
    buildable.setClientId(fluent.getClientId());
    buildable.setClientSecret(fluent.buildClientSecret());
    buildable.setValidIssuerUri(fluent.getValidIssuerUri());
    buildable.setCheckIssuer(fluent.isCheckIssuer());
    buildable.setCheckAudience(fluent.isCheckAudience());
    buildable.setJwksEndpointUri(fluent.getJwksEndpointUri());
    buildable.setJwksRefreshSeconds(fluent.getJwksRefreshSeconds());
    buildable.setJwksMinRefreshPauseSeconds(fluent.getJwksMinRefreshPauseSeconds());
    buildable.setJwksExpirySeconds(fluent.getJwksExpirySeconds());
    buildable.setJwksIgnoreKeyUse(fluent.isJwksIgnoreKeyUse());
    buildable.setIntrospectionEndpointUri(fluent.getIntrospectionEndpointUri());
    buildable.setServerBearerTokenLocation(fluent.getServerBearerTokenLocation());
    buildable.setUserNameClaim(fluent.getUserNameClaim());
    buildable.setUserNamePrefix(fluent.getUserNamePrefix());
    buildable.setFallbackUserNameClaim(fluent.getFallbackUserNameClaim());
    buildable.setFallbackUserNamePrefix(fluent.getFallbackUserNamePrefix());
    buildable.setGroupsClaim(fluent.getGroupsClaim());
    buildable.setGroupsClaimDelimiter(fluent.getGroupsClaimDelimiter());
    buildable.setUserInfoEndpointUri(fluent.getUserInfoEndpointUri());
    buildable.setCheckAccessTokenType(fluent.isCheckAccessTokenType());
    buildable.setValidTokenType(fluent.getValidTokenType());
    buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
    buildable.setEnableECDSA(fluent.getEnableECDSA());
    buildable.setMaxSecondsWithoutReauthentication(fluent.getMaxSecondsWithoutReauthentication());
    buildable.setEnablePlain(fluent.isEnablePlain());
    buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
    buildable.setEnableOauthBearer(fluent.isEnableOauthBearer());
    buildable.setCustomClaimCheck(fluent.getCustomClaimCheck());
    buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
    buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
    buildable.setHttpRetries(fluent.getHttpRetries());
    buildable.setHttpRetryPauseMs(fluent.getHttpRetryPauseMs());
    buildable.setClientScope(fluent.getClientScope());
    buildable.setClientAudience(fluent.getClientAudience());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setFailFast(fluent.isFailFast());
    buildable.setIncludeAcceptHeader(fluent.isIncludeAcceptHeader());
    return buildable;
  }
  

}