package io.strimzi.api.kafka.model.kafka.listener;

import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.common.GenericSecretSourceFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaListenerAuthenticationCustomFluent<A extends KafkaListenerAuthenticationCustomFluent<A>> extends KafkaListenerAuthenticationFluent<A>{
  public KafkaListenerAuthenticationCustomFluent() {
  }
  
  public KafkaListenerAuthenticationCustomFluent(KafkaListenerAuthenticationCustom instance) {
    this.copyInstance(instance);
  }
  private Map<String,Object> listenerConfig;
  private boolean sasl;
  private ArrayList<GenericSecretSourceBuilder> secrets;
  
  protected void copyInstance(KafkaListenerAuthenticationCustom instance) {
    instance = (instance != null ? instance : new KafkaListenerAuthenticationCustom());
    if (instance != null) {
          this.withListenerConfig(instance.getListenerConfig());
          this.withSasl(instance.isSasl());
          this.withSecrets(instance.getSecrets());
        }
  }
  
  public A addToListenerConfig(String key,Object value) {
    if(this.listenerConfig == null && key != null && value != null) { this.listenerConfig = new LinkedHashMap(); }
    if(key != null && value != null) {this.listenerConfig.put(key, value);} return (A)this;
  }
  
  public A addToListenerConfig(Map<String,Object> map) {
    if(this.listenerConfig == null && map != null) { this.listenerConfig = new LinkedHashMap(); }
    if(map != null) { this.listenerConfig.putAll(map);} return (A)this;
  }
  
  public A removeFromListenerConfig(String key) {
    if(this.listenerConfig == null) { return (A) this; }
    if(key != null && this.listenerConfig != null) {this.listenerConfig.remove(key);} return (A)this;
  }
  
  public A removeFromListenerConfig(Map<String,Object> map) {
    if(this.listenerConfig == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.listenerConfig != null){this.listenerConfig.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getListenerConfig() {
    return this.listenerConfig;
  }
  
  public <K,V>A withListenerConfig(Map<String,Object> listenerConfig) {
    if (listenerConfig == null) {
      this.listenerConfig = null;
    } else {
      this.listenerConfig = new LinkedHashMap(listenerConfig);
    }
    return (A) this;
  }
  
  public boolean hasListenerConfig() {
    return this.listenerConfig != null;
  }
  
  public boolean isSasl() {
    return this.sasl;
  }
  
  public A withSasl(boolean sasl) {
    this.sasl = sasl;
    return (A) this;
  }
  
  public boolean hasSasl() {
    return true;
  }
  
  public A addToSecrets(int index,GenericSecretSource item) {
    if (this.secrets == null) {this.secrets = new ArrayList<GenericSecretSourceBuilder>();}
    GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").add(index, builder); secrets.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecrets(int index,GenericSecretSource item) {
    if (this.secrets == null) {this.secrets = new ArrayList<GenericSecretSourceBuilder>();}
    GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
    if (index < 0 || index >= secrets.size()) { _visitables.get("secrets").add(builder); secrets.add(builder); } else { _visitables.get("secrets").set(index, builder); secrets.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecrets(io.strimzi.api.kafka.model.common.GenericSecretSource... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<GenericSecretSourceBuilder>();}
    for (GenericSecretSource item : items) {GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A addAllToSecrets(Collection<GenericSecretSource> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<GenericSecretSourceBuilder>();}
    for (GenericSecretSource item : items) {GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
  }
  
  public A removeFromSecrets(io.strimzi.api.kafka.model.common.GenericSecretSource... items) {
    if (this.secrets == null) return (A)this;
    for (GenericSecretSource item : items) {GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecrets(Collection<GenericSecretSource> items) {
    if (this.secrets == null) return (A)this;
    for (GenericSecretSource item : items) {GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);_visitables.get("secrets").remove(builder); this.secrets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecrets(Predicate<GenericSecretSourceBuilder> predicate) {
    if (secrets == null) return (A) this;
    final Iterator<GenericSecretSourceBuilder> each = secrets.iterator();
    final List visitables = _visitables.get("secrets");
    while (each.hasNext()) {
      GenericSecretSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GenericSecretSource> buildSecrets() {
    return this.secrets != null ? build(secrets) : null;
  }
  
  public GenericSecretSource buildSecret(int index) {
    return this.secrets.get(index).build();
  }
  
  public GenericSecretSource buildFirstSecret() {
    return this.secrets.get(0).build();
  }
  
  public GenericSecretSource buildLastSecret() {
    return this.secrets.get(secrets.size() - 1).build();
  }
  
  public GenericSecretSource buildMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
      for (GenericSecretSourceBuilder item : secrets) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
      for (GenericSecretSourceBuilder item : secrets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSecrets(List<GenericSecretSource> secrets) {
    if (this.secrets != null) {
      this._visitables.get("secrets").clear();
    }
    if (secrets != null) {
        this.secrets = new ArrayList();
        for (GenericSecretSource item : secrets) {
          this.addToSecrets(item);
        }
    } else {
      this.secrets = null;
    }
    return (A) this;
  }
  
  public A withSecrets(io.strimzi.api.kafka.model.common.GenericSecretSource... secrets) {
    if (this.secrets != null) {
        this.secrets.clear();
        _visitables.remove("secrets");
    }
    if (secrets != null) {
      for (GenericSecretSource item : secrets) {
        this.addToSecrets(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSecrets() {
    return this.secrets != null && !this.secrets.isEmpty();
  }
  
  public SecretsNested<A> addNewSecret() {
    return new SecretsNested(-1, null);
  }
  
  public SecretsNested<A> addNewSecretLike(GenericSecretSource item) {
    return new SecretsNested(-1, item);
  }
  
  public SecretsNested<A> setNewSecretLike(int index,GenericSecretSource item) {
    return new SecretsNested(index, item);
  }
  
  public SecretsNested<A> editSecret(int index) {
    if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editFirstSecret() {
    if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
    return setNewSecretLike(0, buildSecret(0));
  }
  
  public SecretsNested<A> editLastSecret() {
    int index = secrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public SecretsNested<A> editMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secrets.size();i++) { 
    if (predicate.test(secrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
    return setNewSecretLike(index, buildSecret(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaListenerAuthenticationCustomFluent that = (KafkaListenerAuthenticationCustomFluent) o;
    if (!java.util.Objects.equals(listenerConfig, that.listenerConfig)) return false;
    if (sasl != that.sasl) return false;
    if (!java.util.Objects.equals(secrets, that.secrets)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(listenerConfig,  sasl,  secrets,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (listenerConfig != null && !listenerConfig.isEmpty()) { sb.append("listenerConfig:"); sb.append(listenerConfig + ","); }
    sb.append("sasl:"); sb.append(sasl + ",");
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSasl() {
    return withSasl(true);
  }
  public class SecretsNested<N> extends GenericSecretSourceFluent<SecretsNested<N>> implements Nested<N>{
    SecretsNested(int index,GenericSecretSource item) {
      this.index = index;
      this.builder = new GenericSecretSourceBuilder(this, item);
    }
    GenericSecretSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaListenerAuthenticationCustomFluent.this.setToSecrets(index,builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }

}