package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaListenerAuthenticationCustomBuilder extends KafkaListenerAuthenticationCustomFluent<KafkaListenerAuthenticationCustomBuilder> implements VisitableBuilder<KafkaListenerAuthenticationCustom,KafkaListenerAuthenticationCustomBuilder>{
  public KafkaListenerAuthenticationCustomBuilder() {
    this(new KafkaListenerAuthenticationCustom());
  }
  
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustomFluent<?> fluent) {
    this(fluent, new KafkaListenerAuthenticationCustom());
  }
  
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustomFluent<?> fluent,KafkaListenerAuthenticationCustom instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaListenerAuthenticationCustomBuilder(KafkaListenerAuthenticationCustom instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaListenerAuthenticationCustomFluent<?> fluent;
  
  public KafkaListenerAuthenticationCustom build() {
    KafkaListenerAuthenticationCustom buildable = new KafkaListenerAuthenticationCustom();
    buildable.setListenerConfig(fluent.getListenerConfig());
    buildable.setSasl(fluent.isSasl());
    buildable.setSecrets(fluent.buildSecrets());
    return buildable;
  }
  

}