package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GenericKafkaListenerFluent<A extends GenericKafkaListenerFluent<A>> extends BaseFluent<A>{
  public GenericKafkaListenerFluent() {
  }
  
  public GenericKafkaListenerFluent(GenericKafkaListener instance) {
    this.copyInstance(instance);
  }
  private String name;
  private int port;
  private KafkaListenerType type;
  private boolean tls;
  private VisitableBuilder<? extends KafkaListenerAuthentication,?> auth;
  private GenericKafkaListenerConfigurationBuilder configuration;
  private List<NetworkPolicyPeer> networkPolicyPeers;
  
  protected void copyInstance(GenericKafkaListener instance) {
    instance = (instance != null ? instance : new GenericKafkaListener());
    if (instance != null) {
          this.withName(instance.getName());
          this.withPort(instance.getPort());
          this.withType(instance.getType());
          this.withTls(instance.isTls());
          this.withAuth(instance.getAuth());
          this.withConfiguration(instance.getConfiguration());
          this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public int getPort() {
    return this.port;
  }
  
  public A withPort(int port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return true;
  }
  
  public KafkaListenerType getType() {
    return this.type;
  }
  
  public A withType(KafkaListenerType type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public boolean isTls() {
    return this.tls;
  }
  
  public A withTls(boolean tls) {
    this.tls = tls;
    return (A) this;
  }
  
  public boolean hasTls() {
    return true;
  }
  
  public KafkaListenerAuthentication buildAuth() {
    return this.auth != null ? this.auth.build() : null;
  }
  
  public A withAuth(KafkaListenerAuthentication auth) {
    if (auth == null) {
        this.auth = null;
        this._visitables.remove("auth");
        return (A) this;
    } else {
        VisitableBuilder<? extends KafkaListenerAuthentication,?> builder = builder(auth);;
        this._visitables.get("auth").clear();
        this._visitables.get("auth").add(builder);
        this.auth = builder;
        return (A) this;
    }
  }
  
  public boolean hasAuth() {
    return this.auth != null;
  }
  
  public KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
    return new KafkaListenerAuthenticationTlsAuthNested(null);
  }
  
  public KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
    return new KafkaListenerAuthenticationTlsAuthNested(item);
  }
  
  public KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
    return new KafkaListenerAuthenticationScramSha512AuthNested(null);
  }
  
  public KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
    return new KafkaListenerAuthenticationScramSha512AuthNested(item);
  }
  
  public KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuth() {
    return new KafkaListenerAuthenticationCustomAuthNested(null);
  }
  
  public KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuthLike(KafkaListenerAuthenticationCustom item) {
    return new KafkaListenerAuthenticationCustomAuthNested(item);
  }
  
  public KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
    return new KafkaListenerAuthenticationOAuthNested(null);
  }
  
  public KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
    return new KafkaListenerAuthenticationOAuthNested(item);
  }
  
  public GenericKafkaListenerConfiguration buildConfiguration() {
    return this.configuration != null ? this.configuration.build() : null;
  }
  
  public A withConfiguration(GenericKafkaListenerConfiguration configuration) {
    this._visitables.remove("configuration");
    if (configuration != null) {
        this.configuration = new GenericKafkaListenerConfigurationBuilder(configuration);
        this._visitables.get("configuration").add(this.configuration);
    } else {
        this.configuration = null;
        this._visitables.get("configuration").remove(this.configuration);
    }
    return (A) this;
  }
  
  public boolean hasConfiguration() {
    return this.configuration != null;
  }
  
  public ConfigurationNested<A> withNewConfiguration() {
    return new ConfigurationNested(null);
  }
  
  public ConfigurationNested<A> withNewConfigurationLike(GenericKafkaListenerConfiguration item) {
    return new ConfigurationNested(item);
  }
  
  public ConfigurationNested<A> editConfiguration() {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(null));
  }
  
  public ConfigurationNested<A> editOrNewConfiguration() {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(new GenericKafkaListenerConfigurationBuilder().build()));
  }
  
  public ConfigurationNested<A> editOrNewConfigurationLike(GenericKafkaListenerConfiguration item) {
    return withNewConfigurationLike(java.util.Optional.ofNullable(buildConfiguration()).orElse(item));
  }
  
  public A addToNetworkPolicyPeers(int index,NetworkPolicyPeer item) {
    if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
    this.networkPolicyPeers.add(index, item);
    return (A)this;
  }
  
  public A setToNetworkPolicyPeers(int index,NetworkPolicyPeer item) {
    if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
    this.networkPolicyPeers.set(index, item); return (A)this;
  }
  
  public A addToNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
    if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
    for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
  }
  
  public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
    if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
    for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
  }
  
  public A removeFromNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
    if (this.networkPolicyPeers == null) return (A)this;
    for (NetworkPolicyPeer item : items) { this.networkPolicyPeers.remove(item);} return (A)this;
  }
  
  public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
    if (this.networkPolicyPeers == null) return (A)this;
    for (NetworkPolicyPeer item : items) { this.networkPolicyPeers.remove(item);} return (A)this;
  }
  
  public List<NetworkPolicyPeer> getNetworkPolicyPeers() {
    return this.networkPolicyPeers;
  }
  
  public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
    return this.networkPolicyPeers.get(index);
  }
  
  public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
    return this.networkPolicyPeers.get(0);
  }
  
  public NetworkPolicyPeer getLastNetworkPolicyPeer() {
    return this.networkPolicyPeers.get(networkPolicyPeers.size() - 1);
  }
  
  public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
      for (NetworkPolicyPeer item : networkPolicyPeers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
      for (NetworkPolicyPeer item : networkPolicyPeers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNetworkPolicyPeers(List<NetworkPolicyPeer> networkPolicyPeers) {
    if (networkPolicyPeers != null) {
        this.networkPolicyPeers = new ArrayList();
        for (NetworkPolicyPeer item : networkPolicyPeers) {
          this.addToNetworkPolicyPeers(item);
        }
    } else {
      this.networkPolicyPeers = null;
    }
    return (A) this;
  }
  
  public A withNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... networkPolicyPeers) {
    if (this.networkPolicyPeers != null) {
        this.networkPolicyPeers.clear();
        _visitables.remove("networkPolicyPeers");
    }
    if (networkPolicyPeers != null) {
      for (NetworkPolicyPeer item : networkPolicyPeers) {
        this.addToNetworkPolicyPeers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNetworkPolicyPeers() {
    return this.networkPolicyPeers != null && !this.networkPolicyPeers.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GenericKafkaListenerFluent that = (GenericKafkaListenerFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (port != that.port) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (tls != that.tls) return false;
    if (!java.util.Objects.equals(auth, that.auth)) return false;
    if (!java.util.Objects.equals(configuration, that.configuration)) return false;
    if (!java.util.Objects.equals(networkPolicyPeers, that.networkPolicyPeers)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  port,  type,  tls,  auth,  configuration,  networkPolicyPeers,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    sb.append("port:"); sb.append(port + ",");
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    sb.append("tls:"); sb.append(tls + ",");
    if (auth != null) { sb.append("auth:"); sb.append(auth + ","); }
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (networkPolicyPeers != null && !networkPolicyPeers.isEmpty()) { sb.append("networkPolicyPeers:"); sb.append(networkPolicyPeers); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.kafka.listener."+"KafkaListenerAuthenticationTls": return (VisitableBuilder<T, ?>)new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls) item);
    case "io.strimzi.api.kafka.model.kafka.listener."+"KafkaListenerAuthenticationScramSha512": return (VisitableBuilder<T, ?>)new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512) item);
    case "io.strimzi.api.kafka.model.kafka.listener."+"KafkaListenerAuthenticationCustom": return (VisitableBuilder<T, ?>)new KafkaListenerAuthenticationCustomBuilder((KafkaListenerAuthenticationCustom) item);
    case "io.strimzi.api.kafka.model.kafka.listener."+"KafkaListenerAuthenticationOAuth": return (VisitableBuilder<T, ?>)new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  
  public A withTls() {
    return withTls(true);
  }
  public class KafkaListenerAuthenticationTlsAuthNested<N> extends KafkaListenerAuthenticationTlsFluent<KafkaListenerAuthenticationTlsAuthNested<N>> implements Nested<N>{
    KafkaListenerAuthenticationTlsAuthNested(KafkaListenerAuthenticationTls item) {
      this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
    }
    KafkaListenerAuthenticationTlsBuilder builder;
    
    public N and() {
      return (N) GenericKafkaListenerFluent.this.withAuth(builder.build());
    }
    
    public N endKafkaListenerAuthenticationTlsAuth() {
      return and();
    }
    
  
  }
  public class KafkaListenerAuthenticationScramSha512AuthNested<N> extends KafkaListenerAuthenticationScramSha512Fluent<KafkaListenerAuthenticationScramSha512AuthNested<N>> implements Nested<N>{
    KafkaListenerAuthenticationScramSha512AuthNested(KafkaListenerAuthenticationScramSha512 item) {
      this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
    }
    KafkaListenerAuthenticationScramSha512Builder builder;
    
    public N and() {
      return (N) GenericKafkaListenerFluent.this.withAuth(builder.build());
    }
    
    public N endKafkaListenerAuthenticationScramSha512Auth() {
      return and();
    }
    
  
  }
  public class KafkaListenerAuthenticationCustomAuthNested<N> extends KafkaListenerAuthenticationCustomFluent<KafkaListenerAuthenticationCustomAuthNested<N>> implements Nested<N>{
    KafkaListenerAuthenticationCustomAuthNested(KafkaListenerAuthenticationCustom item) {
      this.builder = new KafkaListenerAuthenticationCustomBuilder(this, item);
    }
    KafkaListenerAuthenticationCustomBuilder builder;
    
    public N and() {
      return (N) GenericKafkaListenerFluent.this.withAuth(builder.build());
    }
    
    public N endKafkaListenerAuthenticationCustomAuth() {
      return and();
    }
    
  
  }
  public class KafkaListenerAuthenticationOAuthNested<N> extends KafkaListenerAuthenticationOAuthFluent<KafkaListenerAuthenticationOAuthNested<N>> implements Nested<N>{
    KafkaListenerAuthenticationOAuthNested(KafkaListenerAuthenticationOAuth item) {
      this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
    }
    KafkaListenerAuthenticationOAuthBuilder builder;
    
    public N and() {
      return (N) GenericKafkaListenerFluent.this.withAuth(builder.build());
    }
    
    public N endKafkaListenerAuthenticationOAuth() {
      return and();
    }
    
  
  }
  public class ConfigurationNested<N> extends GenericKafkaListenerConfigurationFluent<ConfigurationNested<N>> implements Nested<N>{
    ConfigurationNested(GenericKafkaListenerConfiguration item) {
      this.builder = new GenericKafkaListenerConfigurationBuilder(this, item);
    }
    GenericKafkaListenerConfigurationBuilder builder;
    
    public N and() {
      return (N) GenericKafkaListenerFluent.this.withConfiguration(builder.build());
    }
    
    public N endConfiguration() {
      return and();
    }
    
  
  }

}