package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenericKafkaListenerConfigurationBuilder extends GenericKafkaListenerConfigurationFluent<GenericKafkaListenerConfigurationBuilder> implements VisitableBuilder<GenericKafkaListenerConfiguration,GenericKafkaListenerConfigurationBuilder>{
  public GenericKafkaListenerConfigurationBuilder() {
    this(new GenericKafkaListenerConfiguration());
  }
  
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent) {
    this(fluent, new GenericKafkaListenerConfiguration());
  }
  
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfigurationFluent<?> fluent,GenericKafkaListenerConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenericKafkaListenerConfigurationBuilder(GenericKafkaListenerConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenericKafkaListenerConfigurationFluent<?> fluent;
  
  public GenericKafkaListenerConfiguration build() {
    GenericKafkaListenerConfiguration buildable = new GenericKafkaListenerConfiguration();
    buildable.setBrokerCertChainAndKey(fluent.buildBrokerCertChainAndKey());
    buildable.setControllerClass(fluent.getControllerClass());
    buildable.setPreferredNodePortAddressType(fluent.getPreferredNodePortAddressType());
    buildable.setExternalTrafficPolicy(fluent.getExternalTrafficPolicy());
    buildable.setLoadBalancerSourceRanges(fluent.getLoadBalancerSourceRanges());
    buildable.setFinalizers(fluent.getFinalizers());
    buildable.setUseServiceDnsDomain(fluent.getUseServiceDnsDomain());
    buildable.setBootstrap(fluent.buildBootstrap());
    buildable.setBrokers(fluent.buildBrokers());
    buildable.setMaxConnections(fluent.getMaxConnections());
    buildable.setMaxConnectionCreationRate(fluent.getMaxConnectionCreationRate());
    buildable.setIpFamilyPolicy(fluent.getIpFamilyPolicy());
    buildable.setIpFamilies(fluent.getIpFamilies());
    buildable.setCreateBootstrapService(fluent.getCreateBootstrapService());
    buildable.setPublishNotReadyAddresses(fluent.getPublishNotReadyAddresses());
    buildable.setHostTemplate(fluent.getHostTemplate());
    buildable.setAdvertisedHostTemplate(fluent.getAdvertisedHostTemplate());
    buildable.setAllocateLoadBalancerNodePorts(fluent.getAllocateLoadBalancerNodePorts());
    return buildable;
  }
  

}