package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenericKafkaListenerConfigurationBrokerBuilder extends GenericKafkaListenerConfigurationBrokerFluent<GenericKafkaListenerConfigurationBrokerBuilder> implements VisitableBuilder<GenericKafkaListenerConfigurationBroker,GenericKafkaListenerConfigurationBrokerBuilder>{
  public GenericKafkaListenerConfigurationBrokerBuilder() {
    this(new GenericKafkaListenerConfigurationBroker());
  }
  
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent) {
    this(fluent, new GenericKafkaListenerConfigurationBroker());
  }
  
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,GenericKafkaListenerConfigurationBroker instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBroker instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenericKafkaListenerConfigurationBrokerFluent<?> fluent;
  
  public GenericKafkaListenerConfigurationBroker build() {
    GenericKafkaListenerConfigurationBroker buildable = new GenericKafkaListenerConfigurationBroker();
    buildable.setBroker(fluent.getBroker());
    buildable.setAdvertisedHost(fluent.getAdvertisedHost());
    buildable.setAdvertisedPort(fluent.getAdvertisedPort());
    buildable.setHost(fluent.getHost());
    buildable.setAnnotations(fluent.getAnnotations());
    buildable.setLabels(fluent.getLabels());
    buildable.setNodePort(fluent.getNodePort());
    buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
    buildable.setExternalIPs(fluent.getExternalIPs());
    return buildable;
  }
  

}