package io.strimzi.api.kafka.model.kafka.listener;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GenericKafkaListenerConfigurationBootstrapFluent<A extends GenericKafkaListenerConfigurationBootstrapFluent<A>> extends BaseFluent<A>{
  public GenericKafkaListenerConfigurationBootstrapFluent() {
  }
  
  public GenericKafkaListenerConfigurationBootstrapFluent(GenericKafkaListenerConfigurationBootstrap instance) {
    this.copyInstance(instance);
  }
  private List<String> alternativeNames;
  private String host;
  private Map<String,String> annotations;
  private Map<String,String> labels;
  private Integer nodePort;
  private String loadBalancerIP;
  private List<String> externalIPs;
  
  protected void copyInstance(GenericKafkaListenerConfigurationBootstrap instance) {
    instance = (instance != null ? instance : new GenericKafkaListenerConfigurationBootstrap());
    if (instance != null) {
          this.withAlternativeNames(instance.getAlternativeNames());
          this.withHost(instance.getHost());
          this.withAnnotations(instance.getAnnotations());
          this.withLabels(instance.getLabels());
          this.withNodePort(instance.getNodePort());
          this.withLoadBalancerIP(instance.getLoadBalancerIP());
          this.withExternalIPs(instance.getExternalIPs());
        }
  }
  
  public A addToAlternativeNames(int index,String item) {
    if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
    this.alternativeNames.add(index, item);
    return (A)this;
  }
  
  public A setToAlternativeNames(int index,String item) {
    if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
    this.alternativeNames.set(index, item); return (A)this;
  }
  
  public A addToAlternativeNames(java.lang.String... items) {
    if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
    for (String item : items) {this.alternativeNames.add(item);} return (A)this;
  }
  
  public A addAllToAlternativeNames(Collection<String> items) {
    if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
    for (String item : items) {this.alternativeNames.add(item);} return (A)this;
  }
  
  public A removeFromAlternativeNames(java.lang.String... items) {
    if (this.alternativeNames == null) return (A)this;
    for (String item : items) { this.alternativeNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromAlternativeNames(Collection<String> items) {
    if (this.alternativeNames == null) return (A)this;
    for (String item : items) { this.alternativeNames.remove(item);} return (A)this;
  }
  
  public List<String> getAlternativeNames() {
    return this.alternativeNames;
  }
  
  public String getAlternativeName(int index) {
    return this.alternativeNames.get(index);
  }
  
  public String getFirstAlternativeName() {
    return this.alternativeNames.get(0);
  }
  
  public String getLastAlternativeName() {
    return this.alternativeNames.get(alternativeNames.size() - 1);
  }
  
  public String getMatchingAlternativeName(Predicate<String> predicate) {
      for (String item : alternativeNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAlternativeName(Predicate<String> predicate) {
      for (String item : alternativeNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAlternativeNames(List<String> alternativeNames) {
    if (alternativeNames != null) {
        this.alternativeNames = new ArrayList();
        for (String item : alternativeNames) {
          this.addToAlternativeNames(item);
        }
    } else {
      this.alternativeNames = null;
    }
    return (A) this;
  }
  
  public A withAlternativeNames(java.lang.String... alternativeNames) {
    if (this.alternativeNames != null) {
        this.alternativeNames.clear();
        _visitables.remove("alternativeNames");
    }
    if (alternativeNames != null) {
      for (String item : alternativeNames) {
        this.addToAlternativeNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAlternativeNames() {
    return this.alternativeNames != null && !this.alternativeNames.isEmpty();
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host = host;
    return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) {
      this.annotations = null;
    } else {
      this.annotations = new LinkedHashMap(annotations);
    }
    return (A) this;
  }
  
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getLabels() {
    return this.labels;
  }
  
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) {
      this.labels = null;
    } else {
      this.labels = new LinkedHashMap(labels);
    }
    return (A) this;
  }
  
  public boolean hasLabels() {
    return this.labels != null;
  }
  
  public Integer getNodePort() {
    return this.nodePort;
  }
  
  public A withNodePort(Integer nodePort) {
    this.nodePort = nodePort;
    return (A) this;
  }
  
  public boolean hasNodePort() {
    return this.nodePort != null;
  }
  
  public String getLoadBalancerIP() {
    return this.loadBalancerIP;
  }
  
  public A withLoadBalancerIP(String loadBalancerIP) {
    this.loadBalancerIP = loadBalancerIP;
    return (A) this;
  }
  
  public boolean hasLoadBalancerIP() {
    return this.loadBalancerIP != null;
  }
  
  public A addToExternalIPs(int index,String item) {
    if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
    this.externalIPs.add(index, item);
    return (A)this;
  }
  
  public A setToExternalIPs(int index,String item) {
    if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
    this.externalIPs.set(index, item); return (A)this;
  }
  
  public A addToExternalIPs(java.lang.String... items) {
    if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
    for (String item : items) {this.externalIPs.add(item);} return (A)this;
  }
  
  public A addAllToExternalIPs(Collection<String> items) {
    if (this.externalIPs == null) {this.externalIPs = new ArrayList<String>();}
    for (String item : items) {this.externalIPs.add(item);} return (A)this;
  }
  
  public A removeFromExternalIPs(java.lang.String... items) {
    if (this.externalIPs == null) return (A)this;
    for (String item : items) { this.externalIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromExternalIPs(Collection<String> items) {
    if (this.externalIPs == null) return (A)this;
    for (String item : items) { this.externalIPs.remove(item);} return (A)this;
  }
  
  public List<String> getExternalIPs() {
    return this.externalIPs;
  }
  
  public String getExternalIP(int index) {
    return this.externalIPs.get(index);
  }
  
  public String getFirstExternalIP() {
    return this.externalIPs.get(0);
  }
  
  public String getLastExternalIP() {
    return this.externalIPs.get(externalIPs.size() - 1);
  }
  
  public String getMatchingExternalIP(Predicate<String> predicate) {
      for (String item : externalIPs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingExternalIP(Predicate<String> predicate) {
      for (String item : externalIPs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExternalIPs(List<String> externalIPs) {
    if (externalIPs != null) {
        this.externalIPs = new ArrayList();
        for (String item : externalIPs) {
          this.addToExternalIPs(item);
        }
    } else {
      this.externalIPs = null;
    }
    return (A) this;
  }
  
  public A withExternalIPs(java.lang.String... externalIPs) {
    if (this.externalIPs != null) {
        this.externalIPs.clear();
        _visitables.remove("externalIPs");
    }
    if (externalIPs != null) {
      for (String item : externalIPs) {
        this.addToExternalIPs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExternalIPs() {
    return this.externalIPs != null && !this.externalIPs.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GenericKafkaListenerConfigurationBootstrapFluent that = (GenericKafkaListenerConfigurationBootstrapFluent) o;
    if (!java.util.Objects.equals(alternativeNames, that.alternativeNames)) return false;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;
    if (!java.util.Objects.equals(loadBalancerIP, that.loadBalancerIP)) return false;
    if (!java.util.Objects.equals(externalIPs, that.externalIPs)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(alternativeNames,  host,  annotations,  labels,  nodePort,  loadBalancerIP,  externalIPs,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alternativeNames != null && !alternativeNames.isEmpty()) { sb.append("alternativeNames:"); sb.append(alternativeNames + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (nodePort != null) { sb.append("nodePort:"); sb.append(nodePort + ","); }
    if (loadBalancerIP != null) { sb.append("loadBalancerIP:"); sb.append(loadBalancerIP + ","); }
    if (externalIPs != null && !externalIPs.isEmpty()) { sb.append("externalIPs:"); sb.append(externalIPs); }
    sb.append("}");
    return sb.toString();
  }
  

}