package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenericKafkaListenerConfigurationBootstrapBuilder extends GenericKafkaListenerConfigurationBootstrapFluent<GenericKafkaListenerConfigurationBootstrapBuilder> implements VisitableBuilder<GenericKafkaListenerConfigurationBootstrap,GenericKafkaListenerConfigurationBootstrapBuilder>{
  public GenericKafkaListenerConfigurationBootstrapBuilder() {
    this(new GenericKafkaListenerConfigurationBootstrap());
  }
  
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrapFluent<?> fluent) {
    this(fluent, new GenericKafkaListenerConfigurationBootstrap());
  }
  
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrapFluent<?> fluent,GenericKafkaListenerConfigurationBootstrap instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenericKafkaListenerConfigurationBootstrapBuilder(GenericKafkaListenerConfigurationBootstrap instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenericKafkaListenerConfigurationBootstrapFluent<?> fluent;
  
  public GenericKafkaListenerConfigurationBootstrap build() {
    GenericKafkaListenerConfigurationBootstrap buildable = new GenericKafkaListenerConfigurationBootstrap();
    buildable.setAlternativeNames(fluent.getAlternativeNames());
    buildable.setHost(fluent.getHost());
    buildable.setAnnotations(fluent.getAnnotations());
    buildable.setLabels(fluent.getLabels());
    buildable.setNodePort(fluent.getNodePort());
    buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
    buildable.setExternalIPs(fluent.getExternalIPs());
    return buildable;
  }
  

}