package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GenericKafkaListenerBuilder extends GenericKafkaListenerFluent<GenericKafkaListenerBuilder> implements VisitableBuilder<GenericKafkaListener,GenericKafkaListenerBuilder>{
  public GenericKafkaListenerBuilder() {
    this(new GenericKafkaListener());
  }
  
  public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent) {
    this(fluent, new GenericKafkaListener());
  }
  
  public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,GenericKafkaListener instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GenericKafkaListenerBuilder(GenericKafkaListener instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GenericKafkaListenerFluent<?> fluent;
  
  public GenericKafkaListener build() {
    GenericKafkaListener buildable = new GenericKafkaListener();
    buildable.setName(fluent.getName());
    buildable.setPort(fluent.getPort());
    buildable.setType(fluent.getType());
    buildable.setTls(fluent.isTls());
    buildable.setAuth(fluent.buildAuth());
    buildable.setConfiguration(fluent.buildConfiguration());
    buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
    return buildable;
  }
  

}