package io.strimzi.api.kafka.model.kafka.exporter;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaExporterTemplateBuilder extends KafkaExporterTemplateFluent<KafkaExporterTemplateBuilder> implements VisitableBuilder<KafkaExporterTemplate,KafkaExporterTemplateBuilder>{
  public KafkaExporterTemplateBuilder() {
    this(new KafkaExporterTemplate());
  }
  
  public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent) {
    this(fluent, new KafkaExporterTemplate());
  }
  
  public KafkaExporterTemplateBuilder(KafkaExporterTemplateFluent<?> fluent,KafkaExporterTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaExporterTemplateBuilder(KafkaExporterTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaExporterTemplateFluent<?> fluent;
  
  public KafkaExporterTemplate build() {
    KafkaExporterTemplate buildable = new KafkaExporterTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setService(fluent.buildService());
    buildable.setContainer(fluent.buildContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  

}