package io.strimzi.api.kafka.model.kafka.exporter;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaExporterSpecBuilder extends KafkaExporterSpecFluent<KafkaExporterSpecBuilder> implements VisitableBuilder<KafkaExporterSpec,KafkaExporterSpecBuilder>{
  public KafkaExporterSpecBuilder() {
    this(new KafkaExporterSpec());
  }
  
  public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent) {
    this(fluent, new KafkaExporterSpec());
  }
  
  public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,KafkaExporterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaExporterSpecBuilder(KafkaExporterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaExporterSpecFluent<?> fluent;
  
  public KafkaExporterSpec build() {
    KafkaExporterSpec buildable = new KafkaExporterSpec();
    buildable.setImage(fluent.getImage());
    buildable.setGroupRegex(fluent.getGroupRegex());
    buildable.setTopicRegex(fluent.getTopicRegex());
    buildable.setTopicExcludeRegex(fluent.getTopicExcludeRegex());
    buildable.setGroupExcludeRegex(fluent.getGroupExcludeRegex());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setLogging(fluent.getLogging());
    buildable.setEnableSaramaLogging(fluent.isEnableSaramaLogging());
    buildable.setShowAllOffsets(fluent.isShowAllOffsets());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}