package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TlsSidecarBuilder extends TlsSidecarFluent<TlsSidecarBuilder> implements VisitableBuilder<TlsSidecar,TlsSidecarBuilder>{
  public TlsSidecarBuilder() {
    this(new TlsSidecar());
  }
  
  public TlsSidecarBuilder(TlsSidecarFluent<?> fluent) {
    this(fluent, new TlsSidecar());
  }
  
  public TlsSidecarBuilder(TlsSidecarFluent<?> fluent,TlsSidecar instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TlsSidecarBuilder(TlsSidecar instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TlsSidecarFluent<?> fluent;
  
  public TlsSidecar build() {
    TlsSidecar buildable = new TlsSidecar();
    buildable.setLogLevel(fluent.getLogLevel());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    return buildable;
  }
  

}