package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import java.lang.String;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.ExternalLogging;
import io.strimzi.api.kafka.model.common.JvmOptions;
import java.lang.Long;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EntityUserOperatorSpecFluent<A extends EntityUserOperatorSpecFluent<A>> extends BaseFluent<A>{
  public EntityUserOperatorSpecFluent() {
  }
  
  public EntityUserOperatorSpecFluent(EntityUserOperatorSpec instance) {
    this.copyInstance(instance);
  }
  private String watchedNamespace;
  private String image;
  private String secretPrefix;
  private Long reconciliationIntervalSeconds;
  private Long reconciliationIntervalMs;
  private Long zookeeperSessionTimeoutSeconds;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private ResourceRequirements resources;
  private VisitableBuilder<? extends Logging,?> logging;
  private JvmOptionsBuilder jvmOptions;
  
  protected void copyInstance(EntityUserOperatorSpec instance) {
    instance = (instance != null ? instance : new EntityUserOperatorSpec());
    if (instance != null) {
          this.withWatchedNamespace(instance.getWatchedNamespace());
          this.withImage(instance.getImage());
          this.withSecretPrefix(instance.getSecretPrefix());
          this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
          this.withReconciliationIntervalMs(instance.getReconciliationIntervalMs());
          this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withResources(instance.getResources());
          this.withLogging(instance.getLogging());
          this.withJvmOptions(instance.getJvmOptions());
        }
  }
  
  public String getWatchedNamespace() {
    return this.watchedNamespace;
  }
  
  public A withWatchedNamespace(String watchedNamespace) {
    this.watchedNamespace = watchedNamespace;
    return (A) this;
  }
  
  public boolean hasWatchedNamespace() {
    return this.watchedNamespace != null;
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getSecretPrefix() {
    return this.secretPrefix;
  }
  
  public A withSecretPrefix(String secretPrefix) {
    this.secretPrefix = secretPrefix;
    return (A) this;
  }
  
  public boolean hasSecretPrefix() {
    return this.secretPrefix != null;
  }
  
  public Long getReconciliationIntervalSeconds() {
    return this.reconciliationIntervalSeconds;
  }
  
  public A withReconciliationIntervalSeconds(Long reconciliationIntervalSeconds) {
    this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
    return (A) this;
  }
  
  public boolean hasReconciliationIntervalSeconds() {
    return this.reconciliationIntervalSeconds != null;
  }
  
  public Long getReconciliationIntervalMs() {
    return this.reconciliationIntervalMs;
  }
  
  public A withReconciliationIntervalMs(Long reconciliationIntervalMs) {
    this.reconciliationIntervalMs = reconciliationIntervalMs;
    return (A) this;
  }
  
  public boolean hasReconciliationIntervalMs() {
    return this.reconciliationIntervalMs != null;
  }
  
  public Long getZookeeperSessionTimeoutSeconds() {
    return this.zookeeperSessionTimeoutSeconds;
  }
  
  public A withZookeeperSessionTimeoutSeconds(Long zookeeperSessionTimeoutSeconds) {
    this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
    return (A) this;
  }
  
  public boolean hasZookeeperSessionTimeoutSeconds() {
    return this.zookeeperSessionTimeoutSeconds != null;
  }
  
  public Probe buildLivenessProbe() {
    return this.livenessProbe != null ? this.livenessProbe.build() : null;
  }
  
  public A withLivenessProbe(Probe livenessProbe) {
    this._visitables.remove("livenessProbe");
    if (livenessProbe != null) {
        this.livenessProbe = new ProbeBuilder(livenessProbe);
        this._visitables.get("livenessProbe").add(this.livenessProbe);
    } else {
        this.livenessProbe = null;
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
    }
    return (A) this;
  }
  
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  
  public Probe buildReadinessProbe() {
    return this.readinessProbe != null ? this.readinessProbe.build() : null;
  }
  
  public A withReadinessProbe(Probe readinessProbe) {
    this._visitables.remove("readinessProbe");
    if (readinessProbe != null) {
        this.readinessProbe = new ProbeBuilder(readinessProbe);
        this._visitables.get("readinessProbe").add(this.readinessProbe);
    } else {
        this.readinessProbe = null;
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
    }
    return (A) this;
  }
  
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  
  public ResourceRequirements getResources() {
    return this.resources;
  }
  
  public A withResources(ResourceRequirements resources) {
    this.resources = resources;
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public Logging buildLogging() {
    return this.logging != null ? this.logging.build() : null;
  }
  
  public A withLogging(Logging logging) {
    if (logging == null) {
        this.logging = null;
        this._visitables.remove("logging");
        return (A) this;
    } else {
        VisitableBuilder<? extends Logging,?> builder = builder(logging);;
        this._visitables.get("logging").clear();
        this._visitables.get("logging").add(builder);
        this.logging = builder;
        return (A) this;
    }
  }
  
  public boolean hasLogging() {
    return this.logging != null;
  }
  
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions != null ? this.jvmOptions.build() : null;
  }
  
  public A withJvmOptions(JvmOptions jvmOptions) {
    this._visitables.remove("jvmOptions");
    if (jvmOptions != null) {
        this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
        this._visitables.get("jvmOptions").add(this.jvmOptions);
    } else {
        this.jvmOptions = null;
        this._visitables.get("jvmOptions").remove(this.jvmOptions);
    }
    return (A) this;
  }
  
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EntityUserOperatorSpecFluent that = (EntityUserOperatorSpecFluent) o;
    if (!java.util.Objects.equals(watchedNamespace, that.watchedNamespace)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(secretPrefix, that.secretPrefix)) return false;
    if (!java.util.Objects.equals(reconciliationIntervalSeconds, that.reconciliationIntervalSeconds)) return false;
    if (!java.util.Objects.equals(reconciliationIntervalMs, that.reconciliationIntervalMs)) return false;
    if (!java.util.Objects.equals(zookeeperSessionTimeoutSeconds, that.zookeeperSessionTimeoutSeconds)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(logging, that.logging)) return false;
    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(watchedNamespace,  image,  secretPrefix,  reconciliationIntervalSeconds,  reconciliationIntervalMs,  zookeeperSessionTimeoutSeconds,  livenessProbe,  readinessProbe,  resources,  logging,  jvmOptions,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (watchedNamespace != null) { sb.append("watchedNamespace:"); sb.append(watchedNamespace + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (secretPrefix != null) { sb.append("secretPrefix:"); sb.append(secretPrefix + ","); }
    if (reconciliationIntervalSeconds != null) { sb.append("reconciliationIntervalSeconds:"); sb.append(reconciliationIntervalSeconds + ","); }
    if (reconciliationIntervalMs != null) { sb.append("reconciliationIntervalMs:"); sb.append(reconciliationIntervalMs + ","); }
    if (zookeeperSessionTimeoutSeconds != null) { sb.append("zookeeperSessionTimeoutSeconds:"); sb.append(zookeeperSessionTimeoutSeconds + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model.common."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) EntityUserOperatorSpecFluent.this.withLivenessProbe(builder.build());
    }
    
    public N endLivenessProbe() {
      return and();
    }
    
  
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) EntityUserOperatorSpecFluent.this.withReadinessProbe(builder.build());
    }
    
    public N endReadinessProbe() {
      return and();
    }
    
  
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    
    public N and() {
      return (N) EntityUserOperatorSpecFluent.this.withLogging(builder.build());
    }
    
    public N endInlineLogging() {
      return and();
    }
    
  
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    
    public N and() {
      return (N) EntityUserOperatorSpecFluent.this.withLogging(builder.build());
    }
    
    public N endExternalLogging() {
      return and();
    }
    
  
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    
    public N and() {
      return (N) EntityUserOperatorSpecFluent.this.withJvmOptions(builder.build());
    }
    
    public N endJvmOptions() {
      return and();
    }
    
  
  }

}