package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EntityUserOperatorSpecBuilder extends EntityUserOperatorSpecFluent<EntityUserOperatorSpecBuilder> implements VisitableBuilder<EntityUserOperatorSpec,EntityUserOperatorSpecBuilder>{
  public EntityUserOperatorSpecBuilder() {
    this(new EntityUserOperatorSpec());
  }
  
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent) {
    this(fluent, new EntityUserOperatorSpec());
  }
  
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpecFluent<?> fluent,EntityUserOperatorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EntityUserOperatorSpecBuilder(EntityUserOperatorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EntityUserOperatorSpecFluent<?> fluent;
  
  public EntityUserOperatorSpec build() {
    EntityUserOperatorSpec buildable = new EntityUserOperatorSpec();
    buildable.setWatchedNamespace(fluent.getWatchedNamespace());
    buildable.setImage(fluent.getImage());
    buildable.setSecretPrefix(fluent.getSecretPrefix());
    buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
    buildable.setReconciliationIntervalMs(fluent.getReconciliationIntervalMs());
    buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setResources(fluent.getResources());
    buildable.setLogging(fluent.buildLogging());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    return buildable;
  }
  

}