package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EntityTopicOperatorSpecBuilder extends EntityTopicOperatorSpecFluent<EntityTopicOperatorSpecBuilder> implements VisitableBuilder<EntityTopicOperatorSpec,EntityTopicOperatorSpecBuilder>{
  public EntityTopicOperatorSpecBuilder() {
    this(new EntityTopicOperatorSpec());
  }
  
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent) {
    this(fluent, new EntityTopicOperatorSpec());
  }
  
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpecFluent<?> fluent,EntityTopicOperatorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EntityTopicOperatorSpecBuilder(EntityTopicOperatorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EntityTopicOperatorSpecFluent<?> fluent;
  
  public EntityTopicOperatorSpec build() {
    EntityTopicOperatorSpec buildable = new EntityTopicOperatorSpec();
    buildable.setWatchedNamespace(fluent.getWatchedNamespace());
    buildable.setImage(fluent.getImage());
    buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
    buildable.setReconciliationIntervalMs(fluent.getReconciliationIntervalMs());
    buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
    buildable.setTopicMetadataMaxAttempts(fluent.getTopicMetadataMaxAttempts());
    buildable.setStartupProbe(fluent.buildStartupProbe());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setResources(fluent.getResources());
    buildable.setLogging(fluent.buildLogging());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    return buildable;
  }
  

}