package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EntityOperatorTemplateBuilder extends EntityOperatorTemplateFluent<EntityOperatorTemplateBuilder> implements VisitableBuilder<EntityOperatorTemplate,EntityOperatorTemplateBuilder>{
  public EntityOperatorTemplateBuilder() {
    this(new EntityOperatorTemplate());
  }
  
  public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent) {
    this(fluent, new EntityOperatorTemplate());
  }
  
  public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,EntityOperatorTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EntityOperatorTemplateBuilder(EntityOperatorTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EntityOperatorTemplateFluent<?> fluent;
  
  public EntityOperatorTemplate build() {
    EntityOperatorTemplate buildable = new EntityOperatorTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setEntityOperatorRole(fluent.buildEntityOperatorRole());
    buildable.setTopicOperatorRoleBinding(fluent.buildTopicOperatorRoleBinding());
    buildable.setUserOperatorRoleBinding(fluent.buildUserOperatorRoleBinding());
    buildable.setTopicOperatorContainer(fluent.buildTopicOperatorContainer());
    buildable.setUserOperatorContainer(fluent.buildUserOperatorContainer());
    buildable.setTlsSidecarContainer(fluent.buildTlsSidecarContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  

}