package io.strimzi.api.kafka.model.kafka.entityoperator;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EntityOperatorSpecBuilder extends EntityOperatorSpecFluent<EntityOperatorSpecBuilder> implements VisitableBuilder<EntityOperatorSpec,EntityOperatorSpecBuilder>{
  public EntityOperatorSpecBuilder() {
    this(new EntityOperatorSpec());
  }
  
  public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent) {
    this(fluent, new EntityOperatorSpec());
  }
  
  public EntityOperatorSpecBuilder(EntityOperatorSpecFluent<?> fluent,EntityOperatorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EntityOperatorSpecBuilder(EntityOperatorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EntityOperatorSpecFluent<?> fluent;
  
  public EntityOperatorSpec build() {
    EntityOperatorSpec buildable = new EntityOperatorSpec();
    buildable.setTopicOperator(fluent.buildTopicOperator());
    buildable.setUserOperator(fluent.buildUserOperator());
    buildable.setTlsSidecar(fluent.buildTlsSidecar());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}