package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaAutoRebalanceStatusFluent<A extends KafkaAutoRebalanceStatusFluent<A>> extends BaseFluent<A>{
  public KafkaAutoRebalanceStatusFluent() {
  }
  
  public KafkaAutoRebalanceStatusFluent(KafkaAutoRebalanceStatus instance) {
    this.copyInstance(instance);
  }
  private KafkaAutoRebalanceState state;
  private String lastTransitionTime;
  private ArrayList<KafkaAutoRebalanceStatusBrokersBuilder> modes;
  
  protected void copyInstance(KafkaAutoRebalanceStatus instance) {
    instance = (instance != null ? instance : new KafkaAutoRebalanceStatus());
    if (instance != null) {
          this.withState(instance.getState());
          this.withLastTransitionTime(instance.getLastTransitionTime());
          this.withModes(instance.getModes());
        }
  }
  
  public KafkaAutoRebalanceState getState() {
    return this.state;
  }
  
  public A withState(KafkaAutoRebalanceState state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public String getLastTransitionTime() {
    return this.lastTransitionTime;
  }
  
  public A withLastTransitionTime(String lastTransitionTime) {
    this.lastTransitionTime = lastTransitionTime;
    return (A) this;
  }
  
  public boolean hasLastTransitionTime() {
    return this.lastTransitionTime != null;
  }
  
  public A addToModes(int index,KafkaAutoRebalanceStatusBrokers item) {
    if (this.modes == null) {this.modes = new ArrayList<KafkaAutoRebalanceStatusBrokersBuilder>();}
    KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
    if (index < 0 || index >= modes.size()) { _visitables.get("modes").add(builder); modes.add(builder); } else { _visitables.get("modes").add(index, builder); modes.add(index, builder);}
    return (A)this;
  }
  
  public A setToModes(int index,KafkaAutoRebalanceStatusBrokers item) {
    if (this.modes == null) {this.modes = new ArrayList<KafkaAutoRebalanceStatusBrokersBuilder>();}
    KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);
    if (index < 0 || index >= modes.size()) { _visitables.get("modes").add(builder); modes.add(builder); } else { _visitables.get("modes").set(index, builder); modes.set(index, builder);}
    return (A)this;
  }
  
  public A addToModes(io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokers... items) {
    if (this.modes == null) {this.modes = new ArrayList<KafkaAutoRebalanceStatusBrokersBuilder>();}
    for (KafkaAutoRebalanceStatusBrokers item : items) {KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);_visitables.get("modes").add(builder);this.modes.add(builder);} return (A)this;
  }
  
  public A addAllToModes(Collection<KafkaAutoRebalanceStatusBrokers> items) {
    if (this.modes == null) {this.modes = new ArrayList<KafkaAutoRebalanceStatusBrokersBuilder>();}
    for (KafkaAutoRebalanceStatusBrokers item : items) {KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);_visitables.get("modes").add(builder);this.modes.add(builder);} return (A)this;
  }
  
  public A removeFromModes(io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokers... items) {
    if (this.modes == null) return (A)this;
    for (KafkaAutoRebalanceStatusBrokers item : items) {KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);_visitables.get("modes").remove(builder); this.modes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromModes(Collection<KafkaAutoRebalanceStatusBrokers> items) {
    if (this.modes == null) return (A)this;
    for (KafkaAutoRebalanceStatusBrokers item : items) {KafkaAutoRebalanceStatusBrokersBuilder builder = new KafkaAutoRebalanceStatusBrokersBuilder(item);_visitables.get("modes").remove(builder); this.modes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromModes(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
    if (modes == null) return (A) this;
    final Iterator<KafkaAutoRebalanceStatusBrokersBuilder> each = modes.iterator();
    final List visitables = _visitables.get("modes");
    while (each.hasNext()) {
      KafkaAutoRebalanceStatusBrokersBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KafkaAutoRebalanceStatusBrokers> buildModes() {
    return this.modes != null ? build(modes) : null;
  }
  
  public KafkaAutoRebalanceStatusBrokers buildMode(int index) {
    return this.modes.get(index).build();
  }
  
  public KafkaAutoRebalanceStatusBrokers buildFirstMode() {
    return this.modes.get(0).build();
  }
  
  public KafkaAutoRebalanceStatusBrokers buildLastMode() {
    return this.modes.get(modes.size() - 1).build();
  }
  
  public KafkaAutoRebalanceStatusBrokers buildMatchingMode(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
      for (KafkaAutoRebalanceStatusBrokersBuilder item : modes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMode(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
      for (KafkaAutoRebalanceStatusBrokersBuilder item : modes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withModes(List<KafkaAutoRebalanceStatusBrokers> modes) {
    if (this.modes != null) {
      this._visitables.get("modes").clear();
    }
    if (modes != null) {
        this.modes = new ArrayList();
        for (KafkaAutoRebalanceStatusBrokers item : modes) {
          this.addToModes(item);
        }
    } else {
      this.modes = null;
    }
    return (A) this;
  }
  
  public A withModes(io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokers... modes) {
    if (this.modes != null) {
        this.modes.clear();
        _visitables.remove("modes");
    }
    if (modes != null) {
      for (KafkaAutoRebalanceStatusBrokers item : modes) {
        this.addToModes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasModes() {
    return this.modes != null && !this.modes.isEmpty();
  }
  
  public ModesNested<A> addNewMode() {
    return new ModesNested(-1, null);
  }
  
  public ModesNested<A> addNewModeLike(KafkaAutoRebalanceStatusBrokers item) {
    return new ModesNested(-1, item);
  }
  
  public ModesNested<A> setNewModeLike(int index,KafkaAutoRebalanceStatusBrokers item) {
    return new ModesNested(index, item);
  }
  
  public ModesNested<A> editMode(int index) {
    if (modes.size() <= index) throw new RuntimeException("Can't edit modes. Index exceeds size.");
    return setNewModeLike(index, buildMode(index));
  }
  
  public ModesNested<A> editFirstMode() {
    if (modes.size() == 0) throw new RuntimeException("Can't edit first modes. The list is empty.");
    return setNewModeLike(0, buildMode(0));
  }
  
  public ModesNested<A> editLastMode() {
    int index = modes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last modes. The list is empty.");
    return setNewModeLike(index, buildMode(index));
  }
  
  public ModesNested<A> editMatchingMode(Predicate<KafkaAutoRebalanceStatusBrokersBuilder> predicate) {
    int index = -1;
    for (int i=0;i<modes.size();i++) { 
    if (predicate.test(modes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching modes. No match found.");
    return setNewModeLike(index, buildMode(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaAutoRebalanceStatusFluent that = (KafkaAutoRebalanceStatusFluent) o;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(lastTransitionTime, that.lastTransitionTime)) return false;
    if (!java.util.Objects.equals(modes, that.modes)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(state,  lastTransitionTime,  modes,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (lastTransitionTime != null) { sb.append("lastTransitionTime:"); sb.append(lastTransitionTime + ","); }
    if (modes != null && !modes.isEmpty()) { sb.append("modes:"); sb.append(modes); }
    sb.append("}");
    return sb.toString();
  }
  public class ModesNested<N> extends KafkaAutoRebalanceStatusBrokersFluent<ModesNested<N>> implements Nested<N>{
    ModesNested(int index,KafkaAutoRebalanceStatusBrokers item) {
      this.index = index;
      this.builder = new KafkaAutoRebalanceStatusBrokersBuilder(this, item);
    }
    KafkaAutoRebalanceStatusBrokersBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaAutoRebalanceStatusFluent.this.setToModes(index,builder.build());
    }
    
    public N endMode() {
      return and();
    }
    
  
  }

}