package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaAutoRebalanceStatusBrokersFluent<A extends KafkaAutoRebalanceStatusBrokersFluent<A>> extends BaseFluent<A>{
  public KafkaAutoRebalanceStatusBrokersFluent() {
  }
  
  public KafkaAutoRebalanceStatusBrokersFluent(KafkaAutoRebalanceStatusBrokers instance) {
    this.copyInstance(instance);
  }
  private KafkaAutoRebalanceMode mode;
  private List<Integer> brokers;
  
  protected void copyInstance(KafkaAutoRebalanceStatusBrokers instance) {
    instance = (instance != null ? instance : new KafkaAutoRebalanceStatusBrokers());
    if (instance != null) {
          this.withMode(instance.getMode());
          this.withBrokers(instance.getBrokers());
        }
  }
  
  public KafkaAutoRebalanceMode getMode() {
    return this.mode;
  }
  
  public A withMode(KafkaAutoRebalanceMode mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public A addToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.add(index, item);
    return (A)this;
  }
  
  public A setToBrokers(int index,Integer item) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    this.brokers.set(index, item); return (A)this;
  }
  
  public A addToBrokers(java.lang.Integer... items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  
  public A addAllToBrokers(Collection<Integer> items) {
    if (this.brokers == null) {this.brokers = new ArrayList<Integer>();}
    for (Integer item : items) {this.brokers.add(item);} return (A)this;
  }
  
  public A removeFromBrokers(java.lang.Integer... items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  
  public A removeAllFromBrokers(Collection<Integer> items) {
    if (this.brokers == null) return (A)this;
    for (Integer item : items) { this.brokers.remove(item);} return (A)this;
  }
  
  public List<Integer> getBrokers() {
    return this.brokers;
  }
  
  public Integer getBroker(int index) {
    return this.brokers.get(index);
  }
  
  public Integer getFirstBroker() {
    return this.brokers.get(0);
  }
  
  public Integer getLastBroker() {
    return this.brokers.get(brokers.size() - 1);
  }
  
  public Integer getMatchingBroker(Predicate<Integer> predicate) {
      for (Integer item : brokers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingBroker(Predicate<Integer> predicate) {
      for (Integer item : brokers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBrokers(List<Integer> brokers) {
    if (brokers != null) {
        this.brokers = new ArrayList();
        for (Integer item : brokers) {
          this.addToBrokers(item);
        }
    } else {
      this.brokers = null;
    }
    return (A) this;
  }
  
  public A withBrokers(java.lang.Integer... brokers) {
    if (this.brokers != null) {
        this.brokers.clear();
        _visitables.remove("brokers");
    }
    if (brokers != null) {
      for (Integer item : brokers) {
        this.addToBrokers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBrokers() {
    return this.brokers != null && !this.brokers.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaAutoRebalanceStatusBrokersFluent that = (KafkaAutoRebalanceStatusBrokersFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(brokers, that.brokers)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mode,  brokers,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (brokers != null && !brokers.isEmpty()) { sb.append("brokers:"); sb.append(brokers); }
    sb.append("}");
    return sb.toString();
  }
  

}