package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaAutoRebalanceConfigurationFluent<A extends KafkaAutoRebalanceConfigurationFluent<A>> extends BaseFluent<A>{
  public KafkaAutoRebalanceConfigurationFluent() {
  }
  
  public KafkaAutoRebalanceConfigurationFluent(KafkaAutoRebalanceConfiguration instance) {
    this.copyInstance(instance);
  }
  private KafkaAutoRebalanceMode mode;
  private LocalObjectReference template;
  
  protected void copyInstance(KafkaAutoRebalanceConfiguration instance) {
    instance = (instance != null ? instance : new KafkaAutoRebalanceConfiguration());
    if (instance != null) {
          this.withMode(instance.getMode());
          this.withTemplate(instance.getTemplate());
        }
  }
  
  public KafkaAutoRebalanceMode getMode() {
    return this.mode;
  }
  
  public A withMode(KafkaAutoRebalanceMode mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public LocalObjectReference getTemplate() {
    return this.template;
  }
  
  public A withTemplate(LocalObjectReference template) {
    this.template = template;
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public A withNewTemplate(String name) {
    return (A)withTemplate(new LocalObjectReference(name));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaAutoRebalanceConfigurationFluent that = (KafkaAutoRebalanceConfigurationFluent) o;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mode,  template,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  

}