package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaAutoRebalanceConfigurationBuilder extends KafkaAutoRebalanceConfigurationFluent<KafkaAutoRebalanceConfigurationBuilder> implements VisitableBuilder<KafkaAutoRebalanceConfiguration,KafkaAutoRebalanceConfigurationBuilder>{
  public KafkaAutoRebalanceConfigurationBuilder() {
    this(new KafkaAutoRebalanceConfiguration());
  }
  
  public KafkaAutoRebalanceConfigurationBuilder(KafkaAutoRebalanceConfigurationFluent<?> fluent) {
    this(fluent, new KafkaAutoRebalanceConfiguration());
  }
  
  public KafkaAutoRebalanceConfigurationBuilder(KafkaAutoRebalanceConfigurationFluent<?> fluent,KafkaAutoRebalanceConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaAutoRebalanceConfigurationBuilder(KafkaAutoRebalanceConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaAutoRebalanceConfigurationFluent<?> fluent;
  
  public KafkaAutoRebalanceConfiguration build() {
    KafkaAutoRebalanceConfiguration buildable = new KafkaAutoRebalanceConfiguration();
    buildable.setMode(fluent.getMode());
    buildable.setTemplate(fluent.getTemplate());
    return buildable;
  }
  

}