package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CruiseControlTemplateBuilder extends CruiseControlTemplateFluent<CruiseControlTemplateBuilder> implements VisitableBuilder<CruiseControlTemplate,CruiseControlTemplateBuilder>{
  public CruiseControlTemplateBuilder() {
    this(new CruiseControlTemplate());
  }
  
  public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent) {
    this(fluent, new CruiseControlTemplate());
  }
  
  public CruiseControlTemplateBuilder(CruiseControlTemplateFluent<?> fluent,CruiseControlTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CruiseControlTemplateBuilder(CruiseControlTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CruiseControlTemplateFluent<?> fluent;
  
  public CruiseControlTemplate build() {
    CruiseControlTemplate buildable = new CruiseControlTemplate();
    buildable.setDeployment(fluent.buildDeployment());
    buildable.setPod(fluent.buildPod());
    buildable.setApiService(fluent.buildApiService());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setCruiseControlContainer(fluent.buildCruiseControlContainer());
    buildable.setTlsSidecarContainer(fluent.buildTlsSidecarContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    return buildable;
  }
  

}