package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import java.lang.String;
import io.strimzi.api.kafka.model.common.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.ProbeFluent;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsBuilder;
import io.strimzi.api.kafka.model.common.JvmOptions;
import java.util.Collection;
import io.strimzi.api.kafka.model.common.InlineLoggingFluent;
import java.lang.Object;
import java.util.Map;
import io.strimzi.api.kafka.model.common.JvmOptionsFluent;
import io.strimzi.api.kafka.model.common.InlineLoggingBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.JvmOptionsBuilder;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecarBuilder;
import io.strimzi.api.kafka.model.common.InlineLogging;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.common.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.common.ProbeBuilder;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetrics;
import java.util.Iterator;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecarFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecar;
import io.strimzi.api.kafka.model.common.ExternalLogging;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CruiseControlSpecFluent<A extends CruiseControlSpecFluent<A>> extends BaseFluent<A>{
  public CruiseControlSpecFluent() {
  }
  
  public CruiseControlSpecFluent(CruiseControlSpec instance) {
    this.copyInstance(instance);
  }
  private String image;
  private TlsSidecarBuilder tlsSidecar;
  private ResourceRequirements resources;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private JvmOptionsBuilder jvmOptions;
  private VisitableBuilder<? extends Logging,?> logging;
  private CruiseControlTemplateBuilder template;
  private BrokerCapacityBuilder brokerCapacity;
  private Map<String,Object> config;
  private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
  private VisitableBuilder<? extends CruiseControlApiUsers,?> apiUsers;
  private ArrayList<KafkaAutoRebalanceConfigurationBuilder> autoRebalance;
  
  protected void copyInstance(CruiseControlSpec instance) {
    instance = (instance != null ? instance : new CruiseControlSpec());
    if (instance != null) {
          this.withImage(instance.getImage());
          this.withTlsSidecar(instance.getTlsSidecar());
          this.withResources(instance.getResources());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withJvmOptions(instance.getJvmOptions());
          this.withLogging(instance.getLogging());
          this.withTemplate(instance.getTemplate());
          this.withBrokerCapacity(instance.getBrokerCapacity());
          this.withConfig(instance.getConfig());
          this.withMetricsConfig(instance.getMetricsConfig());
          this.withApiUsers(instance.getApiUsers());
          this.withAutoRebalance(instance.getAutoRebalance());
        }
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public TlsSidecar buildTlsSidecar() {
    return this.tlsSidecar != null ? this.tlsSidecar.build() : null;
  }
  
  public A withTlsSidecar(TlsSidecar tlsSidecar) {
    this._visitables.remove("tlsSidecar");
    if (tlsSidecar != null) {
        this.tlsSidecar = new TlsSidecarBuilder(tlsSidecar);
        this._visitables.get("tlsSidecar").add(this.tlsSidecar);
    } else {
        this.tlsSidecar = null;
        this._visitables.get("tlsSidecar").remove(this.tlsSidecar);
    }
    return (A) this;
  }
  
  public boolean hasTlsSidecar() {
    return this.tlsSidecar != null;
  }
  
  public TlsSidecarNested<A> withNewTlsSidecar() {
    return new TlsSidecarNested(null);
  }
  
  public TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
    return new TlsSidecarNested(item);
  }
  
  public TlsSidecarNested<A> editTlsSidecar() {
    return withNewTlsSidecarLike(java.util.Optional.ofNullable(buildTlsSidecar()).orElse(null));
  }
  
  public TlsSidecarNested<A> editOrNewTlsSidecar() {
    return withNewTlsSidecarLike(java.util.Optional.ofNullable(buildTlsSidecar()).orElse(new TlsSidecarBuilder().build()));
  }
  
  public TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
    return withNewTlsSidecarLike(java.util.Optional.ofNullable(buildTlsSidecar()).orElse(item));
  }
  
  public ResourceRequirements getResources() {
    return this.resources;
  }
  
  public A withResources(ResourceRequirements resources) {
    this.resources = resources;
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public Probe buildLivenessProbe() {
    return this.livenessProbe != null ? this.livenessProbe.build() : null;
  }
  
  public A withLivenessProbe(Probe livenessProbe) {
    this._visitables.remove("livenessProbe");
    if (livenessProbe != null) {
        this.livenessProbe = new ProbeBuilder(livenessProbe);
        this._visitables.get("livenessProbe").add(this.livenessProbe);
    } else {
        this.livenessProbe = null;
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
    }
    return (A) this;
  }
  
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  
  public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  
  public Probe buildReadinessProbe() {
    return this.readinessProbe != null ? this.readinessProbe.build() : null;
  }
  
  public A withReadinessProbe(Probe readinessProbe) {
    this._visitables.remove("readinessProbe");
    if (readinessProbe != null) {
        this.readinessProbe = new ProbeBuilder(readinessProbe);
        this._visitables.get("readinessProbe").add(this.readinessProbe);
    } else {
        this.readinessProbe = null;
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
    }
    return (A) this;
  }
  
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  
  public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
    return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  
  public JvmOptions buildJvmOptions() {
    return this.jvmOptions != null ? this.jvmOptions.build() : null;
  }
  
  public A withJvmOptions(JvmOptions jvmOptions) {
    this._visitables.remove("jvmOptions");
    if (jvmOptions != null) {
        this.jvmOptions = new JvmOptionsBuilder(jvmOptions);
        this._visitables.get("jvmOptions").add(this.jvmOptions);
    } else {
        this.jvmOptions = null;
        this._visitables.get("jvmOptions").remove(this.jvmOptions);
    }
    return (A) this;
  }
  
  public boolean hasJvmOptions() {
    return this.jvmOptions != null;
  }
  
  public JvmOptionsNested<A> withNewJvmOptions() {
    return new JvmOptionsNested(null);
  }
  
  public JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
    return new JvmOptionsNested(item);
  }
  
  public JvmOptionsNested<A> editJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(null));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptions() {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(new JvmOptionsBuilder().build()));
  }
  
  public JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
    return withNewJvmOptionsLike(java.util.Optional.ofNullable(buildJvmOptions()).orElse(item));
  }
  
  public Logging buildLogging() {
    return this.logging != null ? this.logging.build() : null;
  }
  
  public A withLogging(Logging logging) {
    if (logging == null) {
        this.logging = null;
        this._visitables.remove("logging");
        return (A) this;
    } else {
        VisitableBuilder<? extends Logging,?> builder = builder(logging);;
        this._visitables.get("logging").clear();
        this._visitables.get("logging").add(builder);
        this.logging = builder;
        return (A) this;
    }
  }
  
  public boolean hasLogging() {
    return this.logging != null;
  }
  
  public InlineLoggingNested<A> withNewInlineLogging() {
    return new InlineLoggingNested(null);
  }
  
  public InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
    return new InlineLoggingNested(item);
  }
  
  public ExternalLoggingNested<A> withNewExternalLogging() {
    return new ExternalLoggingNested(null);
  }
  
  public ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
    return new ExternalLoggingNested(item);
  }
  
  public CruiseControlTemplate buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(CruiseControlTemplate template) {
    this._visitables.remove("template");
    if (template != null) {
        this.template = new CruiseControlTemplateBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(CruiseControlTemplate item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new CruiseControlTemplateBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(CruiseControlTemplate item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public BrokerCapacity buildBrokerCapacity() {
    return this.brokerCapacity != null ? this.brokerCapacity.build() : null;
  }
  
  public A withBrokerCapacity(BrokerCapacity brokerCapacity) {
    this._visitables.remove("brokerCapacity");
    if (brokerCapacity != null) {
        this.brokerCapacity = new BrokerCapacityBuilder(brokerCapacity);
        this._visitables.get("brokerCapacity").add(this.brokerCapacity);
    } else {
        this.brokerCapacity = null;
        this._visitables.get("brokerCapacity").remove(this.brokerCapacity);
    }
    return (A) this;
  }
  
  public boolean hasBrokerCapacity() {
    return this.brokerCapacity != null;
  }
  
  public BrokerCapacityNested<A> withNewBrokerCapacity() {
    return new BrokerCapacityNested(null);
  }
  
  public BrokerCapacityNested<A> withNewBrokerCapacityLike(BrokerCapacity item) {
    return new BrokerCapacityNested(item);
  }
  
  public BrokerCapacityNested<A> editBrokerCapacity() {
    return withNewBrokerCapacityLike(java.util.Optional.ofNullable(buildBrokerCapacity()).orElse(null));
  }
  
  public BrokerCapacityNested<A> editOrNewBrokerCapacity() {
    return withNewBrokerCapacityLike(java.util.Optional.ofNullable(buildBrokerCapacity()).orElse(new BrokerCapacityBuilder().build()));
  }
  
  public BrokerCapacityNested<A> editOrNewBrokerCapacityLike(BrokerCapacity item) {
    return withNewBrokerCapacityLike(java.util.Optional.ofNullable(buildBrokerCapacity()).orElse(item));
  }
  
  public A addToConfig(String key,Object value) {
    if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap(); }
    if(key != null && value != null) {this.config.put(key, value);} return (A)this;
  }
  
  public A addToConfig(Map<String,Object> map) {
    if(this.config == null && map != null) { this.config = new LinkedHashMap(); }
    if(map != null) { this.config.putAll(map);} return (A)this;
  }
  
  public A removeFromConfig(String key) {
    if(this.config == null) { return (A) this; }
    if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
  }
  
  public A removeFromConfig(Map<String,Object> map) {
    if(this.config == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getConfig() {
    return this.config;
  }
  
  public <K,V>A withConfig(Map<String,Object> config) {
    if (config == null) {
      this.config = null;
    } else {
      this.config = new LinkedHashMap(config);
    }
    return (A) this;
  }
  
  public boolean hasConfig() {
    return this.config != null;
  }
  
  public MetricsConfig buildMetricsConfig() {
    return this.metricsConfig != null ? this.metricsConfig.build() : null;
  }
  
  public A withMetricsConfig(MetricsConfig metricsConfig) {
    if (metricsConfig == null) {
        this.metricsConfig = null;
        this._visitables.remove("metricsConfig");
        return (A) this;
    } else {
        VisitableBuilder<? extends MetricsConfig,?> builder = builder(metricsConfig);;
        this._visitables.get("metricsConfig").clear();
        this._visitables.get("metricsConfig").add(builder);
        this.metricsConfig = builder;
        return (A) this;
    }
  }
  
  public boolean hasMetricsConfig() {
    return this.metricsConfig != null;
  }
  
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
    return new JmxPrometheusExporterMetricsConfigNested(null);
  }
  
  public JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
    return new JmxPrometheusExporterMetricsConfigNested(item);
  }
  
  public CruiseControlApiUsers buildApiUsers() {
    return this.apiUsers != null ? this.apiUsers.build() : null;
  }
  
  public A withApiUsers(CruiseControlApiUsers apiUsers) {
    if (apiUsers == null) {
        this.apiUsers = null;
        this._visitables.remove("apiUsers");
        return (A) this;
    } else {
        VisitableBuilder<? extends CruiseControlApiUsers,?> builder = builder(apiUsers);;
        this._visitables.get("apiUsers").clear();
        this._visitables.get("apiUsers").add(builder);
        this.apiUsers = builder;
        return (A) this;
    }
  }
  
  public boolean hasApiUsers() {
    return this.apiUsers != null;
  }
  
  public HashLoginServiceApiUsersNested<A> withNewHashLoginServiceApiUsers() {
    return new HashLoginServiceApiUsersNested(null);
  }
  
  public HashLoginServiceApiUsersNested<A> withNewHashLoginServiceApiUsersLike(HashLoginServiceApiUsers item) {
    return new HashLoginServiceApiUsersNested(item);
  }
  
  public A addToAutoRebalance(int index,KafkaAutoRebalanceConfiguration item) {
    if (this.autoRebalance == null) {this.autoRebalance = new ArrayList<KafkaAutoRebalanceConfigurationBuilder>();}
    KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
    if (index < 0 || index >= autoRebalance.size()) { _visitables.get("autoRebalance").add(builder); autoRebalance.add(builder); } else { _visitables.get("autoRebalance").add(index, builder); autoRebalance.add(index, builder);}
    return (A)this;
  }
  
  public A setToAutoRebalance(int index,KafkaAutoRebalanceConfiguration item) {
    if (this.autoRebalance == null) {this.autoRebalance = new ArrayList<KafkaAutoRebalanceConfigurationBuilder>();}
    KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);
    if (index < 0 || index >= autoRebalance.size()) { _visitables.get("autoRebalance").add(builder); autoRebalance.add(builder); } else { _visitables.get("autoRebalance").set(index, builder); autoRebalance.set(index, builder);}
    return (A)this;
  }
  
  public A addToAutoRebalance(io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfiguration... items) {
    if (this.autoRebalance == null) {this.autoRebalance = new ArrayList<KafkaAutoRebalanceConfigurationBuilder>();}
    for (KafkaAutoRebalanceConfiguration item : items) {KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);_visitables.get("autoRebalance").add(builder);this.autoRebalance.add(builder);} return (A)this;
  }
  
  public A addAllToAutoRebalance(Collection<KafkaAutoRebalanceConfiguration> items) {
    if (this.autoRebalance == null) {this.autoRebalance = new ArrayList<KafkaAutoRebalanceConfigurationBuilder>();}
    for (KafkaAutoRebalanceConfiguration item : items) {KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);_visitables.get("autoRebalance").add(builder);this.autoRebalance.add(builder);} return (A)this;
  }
  
  public A removeFromAutoRebalance(io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfiguration... items) {
    if (this.autoRebalance == null) return (A)this;
    for (KafkaAutoRebalanceConfiguration item : items) {KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);_visitables.get("autoRebalance").remove(builder); this.autoRebalance.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAutoRebalance(Collection<KafkaAutoRebalanceConfiguration> items) {
    if (this.autoRebalance == null) return (A)this;
    for (KafkaAutoRebalanceConfiguration item : items) {KafkaAutoRebalanceConfigurationBuilder builder = new KafkaAutoRebalanceConfigurationBuilder(item);_visitables.get("autoRebalance").remove(builder); this.autoRebalance.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
    if (autoRebalance == null) return (A) this;
    final Iterator<KafkaAutoRebalanceConfigurationBuilder> each = autoRebalance.iterator();
    final List visitables = _visitables.get("autoRebalance");
    while (each.hasNext()) {
      KafkaAutoRebalanceConfigurationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<KafkaAutoRebalanceConfiguration> buildAutoRebalance() {
    return this.autoRebalance != null ? build(autoRebalance) : null;
  }
  
  public KafkaAutoRebalanceConfiguration buildAutoRebalance(int index) {
    return this.autoRebalance.get(index).build();
  }
  
  public KafkaAutoRebalanceConfiguration buildFirstAutoRebalance() {
    return this.autoRebalance.get(0).build();
  }
  
  public KafkaAutoRebalanceConfiguration buildLastAutoRebalance() {
    return this.autoRebalance.get(autoRebalance.size() - 1).build();
  }
  
  public KafkaAutoRebalanceConfiguration buildMatchingAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
      for (KafkaAutoRebalanceConfigurationBuilder item : autoRebalance) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
      for (KafkaAutoRebalanceConfigurationBuilder item : autoRebalance) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAutoRebalance(List<KafkaAutoRebalanceConfiguration> autoRebalance) {
    if (this.autoRebalance != null) {
      this._visitables.get("autoRebalance").clear();
    }
    if (autoRebalance != null) {
        this.autoRebalance = new ArrayList();
        for (KafkaAutoRebalanceConfiguration item : autoRebalance) {
          this.addToAutoRebalance(item);
        }
    } else {
      this.autoRebalance = null;
    }
    return (A) this;
  }
  
  public A withAutoRebalance(io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfiguration... autoRebalance) {
    if (this.autoRebalance != null) {
        this.autoRebalance.clear();
        _visitables.remove("autoRebalance");
    }
    if (autoRebalance != null) {
      for (KafkaAutoRebalanceConfiguration item : autoRebalance) {
        this.addToAutoRebalance(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAutoRebalance() {
    return this.autoRebalance != null && !this.autoRebalance.isEmpty();
  }
  
  public AutoRebalanceNested<A> addNewAutoRebalance() {
    return new AutoRebalanceNested(-1, null);
  }
  
  public AutoRebalanceNested<A> addNewAutoRebalanceLike(KafkaAutoRebalanceConfiguration item) {
    return new AutoRebalanceNested(-1, item);
  }
  
  public AutoRebalanceNested<A> setNewAutoRebalanceLike(int index,KafkaAutoRebalanceConfiguration item) {
    return new AutoRebalanceNested(index, item);
  }
  
  public AutoRebalanceNested<A> editAutoRebalance(int index) {
    if (autoRebalance.size() <= index) throw new RuntimeException("Can't edit autoRebalance. Index exceeds size.");
    return setNewAutoRebalanceLike(index, buildAutoRebalance(index));
  }
  
  public AutoRebalanceNested<A> editFirstAutoRebalance() {
    if (autoRebalance.size() == 0) throw new RuntimeException("Can't edit first autoRebalance. The list is empty.");
    return setNewAutoRebalanceLike(0, buildAutoRebalance(0));
  }
  
  public AutoRebalanceNested<A> editLastAutoRebalance() {
    int index = autoRebalance.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last autoRebalance. The list is empty.");
    return setNewAutoRebalanceLike(index, buildAutoRebalance(index));
  }
  
  public AutoRebalanceNested<A> editMatchingAutoRebalance(Predicate<KafkaAutoRebalanceConfigurationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<autoRebalance.size();i++) { 
    if (predicate.test(autoRebalance.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching autoRebalance. No match found.");
    return setNewAutoRebalanceLike(index, buildAutoRebalance(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CruiseControlSpecFluent that = (CruiseControlSpecFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(tlsSidecar, that.tlsSidecar)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(jvmOptions, that.jvmOptions)) return false;
    if (!java.util.Objects.equals(logging, that.logging)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(brokerCapacity, that.brokerCapacity)) return false;
    if (!java.util.Objects.equals(config, that.config)) return false;
    if (!java.util.Objects.equals(metricsConfig, that.metricsConfig)) return false;
    if (!java.util.Objects.equals(apiUsers, that.apiUsers)) return false;
    if (!java.util.Objects.equals(autoRebalance, that.autoRebalance)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(image,  tlsSidecar,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  logging,  template,  brokerCapacity,  config,  metricsConfig,  apiUsers,  autoRebalance,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (tlsSidecar != null) { sb.append("tlsSidecar:"); sb.append(tlsSidecar + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (jvmOptions != null) { sb.append("jvmOptions:"); sb.append(jvmOptions + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (brokerCapacity != null) { sb.append("brokerCapacity:"); sb.append(brokerCapacity + ","); }
    if (config != null && !config.isEmpty()) { sb.append("config:"); sb.append(config + ","); }
    if (metricsConfig != null) { sb.append("metricsConfig:"); sb.append(metricsConfig + ","); }
    if (apiUsers != null) { sb.append("apiUsers:"); sb.append(apiUsers + ","); }
    if (autoRebalance != null && !autoRebalance.isEmpty()) { sb.append("autoRebalance:"); sb.append(autoRebalance); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.strimzi.api.kafka.model.common."+"InlineLogging": return (VisitableBuilder<T, ?>)new InlineLoggingBuilder((InlineLogging) item);
    case "io.strimzi.api.kafka.model.common."+"ExternalLogging": return (VisitableBuilder<T, ?>)new ExternalLoggingBuilder((ExternalLogging) item);
    case "io.strimzi.api.kafka.model.common.metrics."+"JmxPrometheusExporterMetrics": return (VisitableBuilder<T, ?>)new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics) item);
    case "io.strimzi.api.kafka.model.kafka.cruisecontrol."+"HashLoginServiceApiUsers": return (VisitableBuilder<T, ?>)new HashLoginServiceApiUsersBuilder((HashLoginServiceApiUsers) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class TlsSidecarNested<N> extends TlsSidecarFluent<TlsSidecarNested<N>> implements Nested<N>{
    TlsSidecarNested(TlsSidecar item) {
      this.builder = new TlsSidecarBuilder(this, item);
    }
    TlsSidecarBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withTlsSidecar(builder.build());
    }
    
    public N endTlsSidecar() {
      return and();
    }
    
  
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withLivenessProbe(builder.build());
    }
    
    public N endLivenessProbe() {
      return and();
    }
    
  
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withReadinessProbe(builder.build());
    }
    
    public N endReadinessProbe() {
      return and();
    }
    
  
  }
  public class JvmOptionsNested<N> extends JvmOptionsFluent<JvmOptionsNested<N>> implements Nested<N>{
    JvmOptionsNested(JvmOptions item) {
      this.builder = new JvmOptionsBuilder(this, item);
    }
    JvmOptionsBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withJvmOptions(builder.build());
    }
    
    public N endJvmOptions() {
      return and();
    }
    
  
  }
  public class InlineLoggingNested<N> extends InlineLoggingFluent<InlineLoggingNested<N>> implements Nested<N>{
    InlineLoggingNested(InlineLogging item) {
      this.builder = new InlineLoggingBuilder(this, item);
    }
    InlineLoggingBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withLogging(builder.build());
    }
    
    public N endInlineLogging() {
      return and();
    }
    
  
  }
  public class ExternalLoggingNested<N> extends ExternalLoggingFluent<ExternalLoggingNested<N>> implements Nested<N>{
    ExternalLoggingNested(ExternalLogging item) {
      this.builder = new ExternalLoggingBuilder(this, item);
    }
    ExternalLoggingBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withLogging(builder.build());
    }
    
    public N endExternalLogging() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends CruiseControlTemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(CruiseControlTemplate item) {
      this.builder = new CruiseControlTemplateBuilder(this, item);
    }
    CruiseControlTemplateBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }
  public class BrokerCapacityNested<N> extends BrokerCapacityFluent<BrokerCapacityNested<N>> implements Nested<N>{
    BrokerCapacityNested(BrokerCapacity item) {
      this.builder = new BrokerCapacityBuilder(this, item);
    }
    BrokerCapacityBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withBrokerCapacity(builder.build());
    }
    
    public N endBrokerCapacity() {
      return and();
    }
    
  
  }
  public class JmxPrometheusExporterMetricsConfigNested<N> extends JmxPrometheusExporterMetricsFluent<JmxPrometheusExporterMetricsConfigNested<N>> implements Nested<N>{
    JmxPrometheusExporterMetricsConfigNested(JmxPrometheusExporterMetrics item) {
      this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
    }
    JmxPrometheusExporterMetricsBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withMetricsConfig(builder.build());
    }
    
    public N endJmxPrometheusExporterMetricsConfig() {
      return and();
    }
    
  
  }
  public class HashLoginServiceApiUsersNested<N> extends HashLoginServiceApiUsersFluent<HashLoginServiceApiUsersNested<N>> implements Nested<N>{
    HashLoginServiceApiUsersNested(HashLoginServiceApiUsers item) {
      this.builder = new HashLoginServiceApiUsersBuilder(this, item);
    }
    HashLoginServiceApiUsersBuilder builder;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.withApiUsers(builder.build());
    }
    
    public N endHashLoginServiceApiUsers() {
      return and();
    }
    
  
  }
  public class AutoRebalanceNested<N> extends KafkaAutoRebalanceConfigurationFluent<AutoRebalanceNested<N>> implements Nested<N>{
    AutoRebalanceNested(int index,KafkaAutoRebalanceConfiguration item) {
      this.index = index;
      this.builder = new KafkaAutoRebalanceConfigurationBuilder(this, item);
    }
    KafkaAutoRebalanceConfigurationBuilder builder;
    int index;
    
    public N and() {
      return (N) CruiseControlSpecFluent.this.setToAutoRebalance(index,builder.build());
    }
    
    public N endAutoRebalance() {
      return and();
    }
    
  
  }

}