package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CruiseControlSpecBuilder extends CruiseControlSpecFluent<CruiseControlSpecBuilder> implements VisitableBuilder<CruiseControlSpec,CruiseControlSpecBuilder>{
  public CruiseControlSpecBuilder() {
    this(new CruiseControlSpec());
  }
  
  public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent) {
    this(fluent, new CruiseControlSpec());
  }
  
  public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent,CruiseControlSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CruiseControlSpecBuilder(CruiseControlSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CruiseControlSpecFluent<?> fluent;
  
  public CruiseControlSpec build() {
    CruiseControlSpec buildable = new CruiseControlSpec();
    buildable.setImage(fluent.getImage());
    buildable.setTlsSidecar(fluent.buildTlsSidecar());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setLogging(fluent.buildLogging());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setBrokerCapacity(fluent.buildBrokerCapacity());
    buildable.setConfig(fluent.getConfig());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setApiUsers(fluent.buildApiUsers());
    buildable.setAutoRebalance(fluent.buildAutoRebalance());
    return buildable;
  }
  

}