package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BrokerCapacityOverrideBuilder extends BrokerCapacityOverrideFluent<BrokerCapacityOverrideBuilder> implements VisitableBuilder<BrokerCapacityOverride,BrokerCapacityOverrideBuilder>{
  public BrokerCapacityOverrideBuilder() {
    this(new BrokerCapacityOverride());
  }
  
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverrideFluent<?> fluent) {
    this(fluent, new BrokerCapacityOverride());
  }
  
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverrideFluent<?> fluent,BrokerCapacityOverride instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BrokerCapacityOverrideBuilder(BrokerCapacityOverride instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BrokerCapacityOverrideFluent<?> fluent;
  
  public BrokerCapacityOverride build() {
    BrokerCapacityOverride buildable = new BrokerCapacityOverride();
    buildable.setBrokers(fluent.getBrokers());
    buildable.setCpu(fluent.getCpu());
    buildable.setInboundNetwork(fluent.getInboundNetwork());
    buildable.setOutboundNetwork(fluent.getOutboundNetwork());
    return buildable;
  }
  

}