package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BrokerCapacityBuilder extends BrokerCapacityFluent<BrokerCapacityBuilder> implements VisitableBuilder<BrokerCapacity,BrokerCapacityBuilder>{
  public BrokerCapacityBuilder() {
    this(new BrokerCapacity());
  }
  
  public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent) {
    this(fluent, new BrokerCapacity());
  }
  
  public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,BrokerCapacity instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BrokerCapacityBuilder(BrokerCapacity instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BrokerCapacityFluent<?> fluent;
  
  public BrokerCapacity build() {
    BrokerCapacity buildable = new BrokerCapacity();
    buildable.setDisk(fluent.getDisk());
    buildable.setCpuUtilization(fluent.getCpuUtilization());
    buildable.setCpu(fluent.getCpu());
    buildable.setInboundNetwork(fluent.getInboundNetwork());
    buildable.setOutboundNetwork(fluent.getOutboundNetwork());
    buildable.setOverrides(fluent.buildOverrides());
    return buildable;
  }
  

}