package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentClaimStorageOverrideBuilder extends PersistentClaimStorageOverrideFluent<PersistentClaimStorageOverrideBuilder> implements VisitableBuilder<PersistentClaimStorageOverride,PersistentClaimStorageOverrideBuilder>{
  public PersistentClaimStorageOverrideBuilder() {
    this(new PersistentClaimStorageOverride());
  }
  
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent) {
    this(fluent, new PersistentClaimStorageOverride());
  }
  
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,PersistentClaimStorageOverride instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverride instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentClaimStorageOverrideFluent<?> fluent;
  
  public PersistentClaimStorageOverride build() {
    PersistentClaimStorageOverride buildable = new PersistentClaimStorageOverride();
    buildable.setBroker(fluent.getBroker());
    buildable.setStorageClass(fluent.getStorageClass());
    return buildable;
  }
  

}