package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentClaimStorageBuilder extends PersistentClaimStorageFluent<PersistentClaimStorageBuilder> implements VisitableBuilder<PersistentClaimStorage,PersistentClaimStorageBuilder>{
  public PersistentClaimStorageBuilder() {
    this(new PersistentClaimStorage());
  }
  
  public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent) {
    this(fluent, new PersistentClaimStorage());
  }
  
  public PersistentClaimStorageBuilder(PersistentClaimStorageFluent<?> fluent,PersistentClaimStorage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentClaimStorageBuilder(PersistentClaimStorage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentClaimStorageFluent<?> fluent;
  
  public PersistentClaimStorage build() {
    PersistentClaimStorage buildable = new PersistentClaimStorage();
    buildable.setSize(fluent.getSize());
    buildable.setStorageClass(fluent.getStorageClass());
    buildable.setSelector(fluent.getSelector());
    buildable.setDeleteClaim(fluent.isDeleteClaim());
    buildable.setOverrides(fluent.buildOverrides());
    buildable.setId(fluent.getId());
    buildable.setKraftMetadata(fluent.getKraftMetadata());
    return buildable;
  }
  

}