package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatus;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.kafka.listener.ListenerStatus;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.kafka.listener.ListenerStatusBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.kafka.listener.ListenerStatusFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaStatusFluent<A extends KafkaStatusFluent<A>> extends StatusFluent<A>{
  public KafkaStatusFluent() {
  }
  
  public KafkaStatusFluent(KafkaStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ListenerStatusBuilder> listeners;
  private ArrayList<UsedNodePoolStatusBuilder> kafkaNodePools;
  private List<Integer> registeredNodeIds;
  private String clusterId;
  private String operatorLastSuccessfulVersion;
  private String kafkaVersion;
  private String kafkaMetadataVersion;
  private KafkaMetadataState kafkaMetadataState;
  private KafkaAutoRebalanceStatusBuilder autoRebalance;
  
  protected void copyInstance(KafkaStatus instance) {
    instance = (instance != null ? instance : new KafkaStatus());
    if (instance != null) {
          this.withListeners(instance.getListeners());
          this.withKafkaNodePools(instance.getKafkaNodePools());
          this.withRegisteredNodeIds(instance.getRegisteredNodeIds());
          this.withClusterId(instance.getClusterId());
          this.withOperatorLastSuccessfulVersion(instance.getOperatorLastSuccessfulVersion());
          this.withKafkaVersion(instance.getKafkaVersion());
          this.withKafkaMetadataVersion(instance.getKafkaMetadataVersion());
          this.withKafkaMetadataState(instance.getKafkaMetadataState());
          this.withAutoRebalance(instance.getAutoRebalance());
          this.withConditions(instance.getConditions());
          this.withObservedGeneration(instance.getObservedGeneration());
        }
  }
  
  public A addToListeners(int index,ListenerStatus item) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
    ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
    if (index < 0 || index >= listeners.size()) { _visitables.get("listeners").add(builder); listeners.add(builder); } else { _visitables.get("listeners").add(index, builder); listeners.add(index, builder);}
    return (A)this;
  }
  
  public A setToListeners(int index,ListenerStatus item) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
    ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
    if (index < 0 || index >= listeners.size()) { _visitables.get("listeners").add(builder); listeners.add(builder); } else { _visitables.get("listeners").set(index, builder); listeners.set(index, builder);}
    return (A)this;
  }
  
  public A addToListeners(io.strimzi.api.kafka.model.kafka.listener.ListenerStatus... items) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
    for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
  }
  
  public A addAllToListeners(Collection<ListenerStatus> items) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
    for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
  }
  
  public A removeFromListeners(io.strimzi.api.kafka.model.kafka.listener.ListenerStatus... items) {
    if (this.listeners == null) return (A)this;
    for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").remove(builder); this.listeners.remove(builder);} return (A)this;
  }
  
  public A removeAllFromListeners(Collection<ListenerStatus> items) {
    if (this.listeners == null) return (A)this;
    for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").remove(builder); this.listeners.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromListeners(Predicate<ListenerStatusBuilder> predicate) {
    if (listeners == null) return (A) this;
    final Iterator<ListenerStatusBuilder> each = listeners.iterator();
    final List visitables = _visitables.get("listeners");
    while (each.hasNext()) {
      ListenerStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ListenerStatus> buildListeners() {
    return this.listeners != null ? build(listeners) : null;
  }
  
  public ListenerStatus buildListener(int index) {
    return this.listeners.get(index).build();
  }
  
  public ListenerStatus buildFirstListener() {
    return this.listeners.get(0).build();
  }
  
  public ListenerStatus buildLastListener() {
    return this.listeners.get(listeners.size() - 1).build();
  }
  
  public ListenerStatus buildMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
      for (ListenerStatusBuilder item : listeners) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
      for (ListenerStatusBuilder item : listeners) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withListeners(List<ListenerStatus> listeners) {
    if (this.listeners != null) {
      this._visitables.get("listeners").clear();
    }
    if (listeners != null) {
        this.listeners = new ArrayList();
        for (ListenerStatus item : listeners) {
          this.addToListeners(item);
        }
    } else {
      this.listeners = null;
    }
    return (A) this;
  }
  
  public A withListeners(io.strimzi.api.kafka.model.kafka.listener.ListenerStatus... listeners) {
    if (this.listeners != null) {
        this.listeners.clear();
        _visitables.remove("listeners");
    }
    if (listeners != null) {
      for (ListenerStatus item : listeners) {
        this.addToListeners(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasListeners() {
    return this.listeners != null && !this.listeners.isEmpty();
  }
  
  public ListenersNested<A> addNewListener() {
    return new ListenersNested(-1, null);
  }
  
  public ListenersNested<A> addNewListenerLike(ListenerStatus item) {
    return new ListenersNested(-1, item);
  }
  
  public ListenersNested<A> setNewListenerLike(int index,ListenerStatus item) {
    return new ListenersNested(index, item);
  }
  
  public ListenersNested<A> editListener(int index) {
    if (listeners.size() <= index) throw new RuntimeException("Can't edit listeners. Index exceeds size.");
    return setNewListenerLike(index, buildListener(index));
  }
  
  public ListenersNested<A> editFirstListener() {
    if (listeners.size() == 0) throw new RuntimeException("Can't edit first listeners. The list is empty.");
    return setNewListenerLike(0, buildListener(0));
  }
  
  public ListenersNested<A> editLastListener() {
    int index = listeners.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last listeners. The list is empty.");
    return setNewListenerLike(index, buildListener(index));
  }
  
  public ListenersNested<A> editMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<listeners.size();i++) { 
    if (predicate.test(listeners.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching listeners. No match found.");
    return setNewListenerLike(index, buildListener(index));
  }
  
  public A addToKafkaNodePools(int index,UsedNodePoolStatus item) {
    if (this.kafkaNodePools == null) {this.kafkaNodePools = new ArrayList<UsedNodePoolStatusBuilder>();}
    UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
    if (index < 0 || index >= kafkaNodePools.size()) { _visitables.get("kafkaNodePools").add(builder); kafkaNodePools.add(builder); } else { _visitables.get("kafkaNodePools").add(index, builder); kafkaNodePools.add(index, builder);}
    return (A)this;
  }
  
  public A setToKafkaNodePools(int index,UsedNodePoolStatus item) {
    if (this.kafkaNodePools == null) {this.kafkaNodePools = new ArrayList<UsedNodePoolStatusBuilder>();}
    UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);
    if (index < 0 || index >= kafkaNodePools.size()) { _visitables.get("kafkaNodePools").add(builder); kafkaNodePools.add(builder); } else { _visitables.get("kafkaNodePools").set(index, builder); kafkaNodePools.set(index, builder);}
    return (A)this;
  }
  
  public A addToKafkaNodePools(io.strimzi.api.kafka.model.kafka.UsedNodePoolStatus... items) {
    if (this.kafkaNodePools == null) {this.kafkaNodePools = new ArrayList<UsedNodePoolStatusBuilder>();}
    for (UsedNodePoolStatus item : items) {UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);_visitables.get("kafkaNodePools").add(builder);this.kafkaNodePools.add(builder);} return (A)this;
  }
  
  public A addAllToKafkaNodePools(Collection<UsedNodePoolStatus> items) {
    if (this.kafkaNodePools == null) {this.kafkaNodePools = new ArrayList<UsedNodePoolStatusBuilder>();}
    for (UsedNodePoolStatus item : items) {UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);_visitables.get("kafkaNodePools").add(builder);this.kafkaNodePools.add(builder);} return (A)this;
  }
  
  public A removeFromKafkaNodePools(io.strimzi.api.kafka.model.kafka.UsedNodePoolStatus... items) {
    if (this.kafkaNodePools == null) return (A)this;
    for (UsedNodePoolStatus item : items) {UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);_visitables.get("kafkaNodePools").remove(builder); this.kafkaNodePools.remove(builder);} return (A)this;
  }
  
  public A removeAllFromKafkaNodePools(Collection<UsedNodePoolStatus> items) {
    if (this.kafkaNodePools == null) return (A)this;
    for (UsedNodePoolStatus item : items) {UsedNodePoolStatusBuilder builder = new UsedNodePoolStatusBuilder(item);_visitables.get("kafkaNodePools").remove(builder); this.kafkaNodePools.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromKafkaNodePools(Predicate<UsedNodePoolStatusBuilder> predicate) {
    if (kafkaNodePools == null) return (A) this;
    final Iterator<UsedNodePoolStatusBuilder> each = kafkaNodePools.iterator();
    final List visitables = _visitables.get("kafkaNodePools");
    while (each.hasNext()) {
      UsedNodePoolStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<UsedNodePoolStatus> buildKafkaNodePools() {
    return this.kafkaNodePools != null ? build(kafkaNodePools) : null;
  }
  
  public UsedNodePoolStatus buildKafkaNodePool(int index) {
    return this.kafkaNodePools.get(index).build();
  }
  
  public UsedNodePoolStatus buildFirstKafkaNodePool() {
    return this.kafkaNodePools.get(0).build();
  }
  
  public UsedNodePoolStatus buildLastKafkaNodePool() {
    return this.kafkaNodePools.get(kafkaNodePools.size() - 1).build();
  }
  
  public UsedNodePoolStatus buildMatchingKafkaNodePool(Predicate<UsedNodePoolStatusBuilder> predicate) {
      for (UsedNodePoolStatusBuilder item : kafkaNodePools) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingKafkaNodePool(Predicate<UsedNodePoolStatusBuilder> predicate) {
      for (UsedNodePoolStatusBuilder item : kafkaNodePools) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withKafkaNodePools(List<UsedNodePoolStatus> kafkaNodePools) {
    if (this.kafkaNodePools != null) {
      this._visitables.get("kafkaNodePools").clear();
    }
    if (kafkaNodePools != null) {
        this.kafkaNodePools = new ArrayList();
        for (UsedNodePoolStatus item : kafkaNodePools) {
          this.addToKafkaNodePools(item);
        }
    } else {
      this.kafkaNodePools = null;
    }
    return (A) this;
  }
  
  public A withKafkaNodePools(io.strimzi.api.kafka.model.kafka.UsedNodePoolStatus... kafkaNodePools) {
    if (this.kafkaNodePools != null) {
        this.kafkaNodePools.clear();
        _visitables.remove("kafkaNodePools");
    }
    if (kafkaNodePools != null) {
      for (UsedNodePoolStatus item : kafkaNodePools) {
        this.addToKafkaNodePools(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasKafkaNodePools() {
    return this.kafkaNodePools != null && !this.kafkaNodePools.isEmpty();
  }
  
  public KafkaNodePoolsNested<A> addNewKafkaNodePool() {
    return new KafkaNodePoolsNested(-1, null);
  }
  
  public KafkaNodePoolsNested<A> addNewKafkaNodePoolLike(UsedNodePoolStatus item) {
    return new KafkaNodePoolsNested(-1, item);
  }
  
  public KafkaNodePoolsNested<A> setNewKafkaNodePoolLike(int index,UsedNodePoolStatus item) {
    return new KafkaNodePoolsNested(index, item);
  }
  
  public KafkaNodePoolsNested<A> editKafkaNodePool(int index) {
    if (kafkaNodePools.size() <= index) throw new RuntimeException("Can't edit kafkaNodePools. Index exceeds size.");
    return setNewKafkaNodePoolLike(index, buildKafkaNodePool(index));
  }
  
  public KafkaNodePoolsNested<A> editFirstKafkaNodePool() {
    if (kafkaNodePools.size() == 0) throw new RuntimeException("Can't edit first kafkaNodePools. The list is empty.");
    return setNewKafkaNodePoolLike(0, buildKafkaNodePool(0));
  }
  
  public KafkaNodePoolsNested<A> editLastKafkaNodePool() {
    int index = kafkaNodePools.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kafkaNodePools. The list is empty.");
    return setNewKafkaNodePoolLike(index, buildKafkaNodePool(index));
  }
  
  public KafkaNodePoolsNested<A> editMatchingKafkaNodePool(Predicate<UsedNodePoolStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kafkaNodePools.size();i++) { 
    if (predicate.test(kafkaNodePools.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kafkaNodePools. No match found.");
    return setNewKafkaNodePoolLike(index, buildKafkaNodePool(index));
  }
  
  public A addToRegisteredNodeIds(int index,Integer item) {
    if (this.registeredNodeIds == null) {this.registeredNodeIds = new ArrayList<Integer>();}
    this.registeredNodeIds.add(index, item);
    return (A)this;
  }
  
  public A setToRegisteredNodeIds(int index,Integer item) {
    if (this.registeredNodeIds == null) {this.registeredNodeIds = new ArrayList<Integer>();}
    this.registeredNodeIds.set(index, item); return (A)this;
  }
  
  public A addToRegisteredNodeIds(java.lang.Integer... items) {
    if (this.registeredNodeIds == null) {this.registeredNodeIds = new ArrayList<Integer>();}
    for (Integer item : items) {this.registeredNodeIds.add(item);} return (A)this;
  }
  
  public A addAllToRegisteredNodeIds(Collection<Integer> items) {
    if (this.registeredNodeIds == null) {this.registeredNodeIds = new ArrayList<Integer>();}
    for (Integer item : items) {this.registeredNodeIds.add(item);} return (A)this;
  }
  
  public A removeFromRegisteredNodeIds(java.lang.Integer... items) {
    if (this.registeredNodeIds == null) return (A)this;
    for (Integer item : items) { this.registeredNodeIds.remove(item);} return (A)this;
  }
  
  public A removeAllFromRegisteredNodeIds(Collection<Integer> items) {
    if (this.registeredNodeIds == null) return (A)this;
    for (Integer item : items) { this.registeredNodeIds.remove(item);} return (A)this;
  }
  
  public List<Integer> getRegisteredNodeIds() {
    return this.registeredNodeIds;
  }
  
  public Integer getRegisteredNodeId(int index) {
    return this.registeredNodeIds.get(index);
  }
  
  public Integer getFirstRegisteredNodeId() {
    return this.registeredNodeIds.get(0);
  }
  
  public Integer getLastRegisteredNodeId() {
    return this.registeredNodeIds.get(registeredNodeIds.size() - 1);
  }
  
  public Integer getMatchingRegisteredNodeId(Predicate<Integer> predicate) {
      for (Integer item : registeredNodeIds) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingRegisteredNodeId(Predicate<Integer> predicate) {
      for (Integer item : registeredNodeIds) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRegisteredNodeIds(List<Integer> registeredNodeIds) {
    if (registeredNodeIds != null) {
        this.registeredNodeIds = new ArrayList();
        for (Integer item : registeredNodeIds) {
          this.addToRegisteredNodeIds(item);
        }
    } else {
      this.registeredNodeIds = null;
    }
    return (A) this;
  }
  
  public A withRegisteredNodeIds(java.lang.Integer... registeredNodeIds) {
    if (this.registeredNodeIds != null) {
        this.registeredNodeIds.clear();
        _visitables.remove("registeredNodeIds");
    }
    if (registeredNodeIds != null) {
      for (Integer item : registeredNodeIds) {
        this.addToRegisteredNodeIds(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRegisteredNodeIds() {
    return this.registeredNodeIds != null && !this.registeredNodeIds.isEmpty();
  }
  
  public String getClusterId() {
    return this.clusterId;
  }
  
  public A withClusterId(String clusterId) {
    this.clusterId = clusterId;
    return (A) this;
  }
  
  public boolean hasClusterId() {
    return this.clusterId != null;
  }
  
  public String getOperatorLastSuccessfulVersion() {
    return this.operatorLastSuccessfulVersion;
  }
  
  public A withOperatorLastSuccessfulVersion(String operatorLastSuccessfulVersion) {
    this.operatorLastSuccessfulVersion = operatorLastSuccessfulVersion;
    return (A) this;
  }
  
  public boolean hasOperatorLastSuccessfulVersion() {
    return this.operatorLastSuccessfulVersion != null;
  }
  
  public String getKafkaVersion() {
    return this.kafkaVersion;
  }
  
  public A withKafkaVersion(String kafkaVersion) {
    this.kafkaVersion = kafkaVersion;
    return (A) this;
  }
  
  public boolean hasKafkaVersion() {
    return this.kafkaVersion != null;
  }
  
  public String getKafkaMetadataVersion() {
    return this.kafkaMetadataVersion;
  }
  
  public A withKafkaMetadataVersion(String kafkaMetadataVersion) {
    this.kafkaMetadataVersion = kafkaMetadataVersion;
    return (A) this;
  }
  
  public boolean hasKafkaMetadataVersion() {
    return this.kafkaMetadataVersion != null;
  }
  
  public KafkaMetadataState getKafkaMetadataState() {
    return this.kafkaMetadataState;
  }
  
  public A withKafkaMetadataState(KafkaMetadataState kafkaMetadataState) {
    this.kafkaMetadataState = kafkaMetadataState;
    return (A) this;
  }
  
  public boolean hasKafkaMetadataState() {
    return this.kafkaMetadataState != null;
  }
  
  public KafkaAutoRebalanceStatus buildAutoRebalance() {
    return this.autoRebalance != null ? this.autoRebalance.build() : null;
  }
  
  public A withAutoRebalance(KafkaAutoRebalanceStatus autoRebalance) {
    this._visitables.remove("autoRebalance");
    if (autoRebalance != null) {
        this.autoRebalance = new KafkaAutoRebalanceStatusBuilder(autoRebalance);
        this._visitables.get("autoRebalance").add(this.autoRebalance);
    } else {
        this.autoRebalance = null;
        this._visitables.get("autoRebalance").remove(this.autoRebalance);
    }
    return (A) this;
  }
  
  public boolean hasAutoRebalance() {
    return this.autoRebalance != null;
  }
  
  public AutoRebalanceNested<A> withNewAutoRebalance() {
    return new AutoRebalanceNested(null);
  }
  
  public AutoRebalanceNested<A> withNewAutoRebalanceLike(KafkaAutoRebalanceStatus item) {
    return new AutoRebalanceNested(item);
  }
  
  public AutoRebalanceNested<A> editAutoRebalance() {
    return withNewAutoRebalanceLike(java.util.Optional.ofNullable(buildAutoRebalance()).orElse(null));
  }
  
  public AutoRebalanceNested<A> editOrNewAutoRebalance() {
    return withNewAutoRebalanceLike(java.util.Optional.ofNullable(buildAutoRebalance()).orElse(new KafkaAutoRebalanceStatusBuilder().build()));
  }
  
  public AutoRebalanceNested<A> editOrNewAutoRebalanceLike(KafkaAutoRebalanceStatus item) {
    return withNewAutoRebalanceLike(java.util.Optional.ofNullable(buildAutoRebalance()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaStatusFluent that = (KafkaStatusFluent) o;
    if (!java.util.Objects.equals(listeners, that.listeners)) return false;
    if (!java.util.Objects.equals(kafkaNodePools, that.kafkaNodePools)) return false;
    if (!java.util.Objects.equals(registeredNodeIds, that.registeredNodeIds)) return false;
    if (!java.util.Objects.equals(clusterId, that.clusterId)) return false;
    if (!java.util.Objects.equals(operatorLastSuccessfulVersion, that.operatorLastSuccessfulVersion)) return false;
    if (!java.util.Objects.equals(kafkaVersion, that.kafkaVersion)) return false;
    if (!java.util.Objects.equals(kafkaMetadataVersion, that.kafkaMetadataVersion)) return false;
    if (!java.util.Objects.equals(kafkaMetadataState, that.kafkaMetadataState)) return false;
    if (!java.util.Objects.equals(autoRebalance, that.autoRebalance)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(listeners,  kafkaNodePools,  registeredNodeIds,  clusterId,  operatorLastSuccessfulVersion,  kafkaVersion,  kafkaMetadataVersion,  kafkaMetadataState,  autoRebalance,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (listeners != null && !listeners.isEmpty()) { sb.append("listeners:"); sb.append(listeners + ","); }
    if (kafkaNodePools != null && !kafkaNodePools.isEmpty()) { sb.append("kafkaNodePools:"); sb.append(kafkaNodePools + ","); }
    if (registeredNodeIds != null && !registeredNodeIds.isEmpty()) { sb.append("registeredNodeIds:"); sb.append(registeredNodeIds + ","); }
    if (clusterId != null) { sb.append("clusterId:"); sb.append(clusterId + ","); }
    if (operatorLastSuccessfulVersion != null) { sb.append("operatorLastSuccessfulVersion:"); sb.append(operatorLastSuccessfulVersion + ","); }
    if (kafkaVersion != null) { sb.append("kafkaVersion:"); sb.append(kafkaVersion + ","); }
    if (kafkaMetadataVersion != null) { sb.append("kafkaMetadataVersion:"); sb.append(kafkaMetadataVersion + ","); }
    if (kafkaMetadataState != null) { sb.append("kafkaMetadataState:"); sb.append(kafkaMetadataState + ","); }
    if (autoRebalance != null) { sb.append("autoRebalance:"); sb.append(autoRebalance); }
    sb.append("}");
    return sb.toString();
  }
  public class ListenersNested<N> extends ListenerStatusFluent<ListenersNested<N>> implements Nested<N>{
    ListenersNested(int index,ListenerStatus item) {
      this.index = index;
      this.builder = new ListenerStatusBuilder(this, item);
    }
    ListenerStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaStatusFluent.this.setToListeners(index,builder.build());
    }
    
    public N endListener() {
      return and();
    }
    
  
  }
  public class KafkaNodePoolsNested<N> extends UsedNodePoolStatusFluent<KafkaNodePoolsNested<N>> implements Nested<N>{
    KafkaNodePoolsNested(int index,UsedNodePoolStatus item) {
      this.index = index;
      this.builder = new UsedNodePoolStatusBuilder(this, item);
    }
    UsedNodePoolStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaStatusFluent.this.setToKafkaNodePools(index,builder.build());
    }
    
    public N endKafkaNodePool() {
      return and();
    }
    
  
  }
  public class AutoRebalanceNested<N> extends KafkaAutoRebalanceStatusFluent<AutoRebalanceNested<N>> implements Nested<N>{
    AutoRebalanceNested(KafkaAutoRebalanceStatus item) {
      this.builder = new KafkaAutoRebalanceStatusBuilder(this, item);
    }
    KafkaAutoRebalanceStatusBuilder builder;
    
    public N and() {
      return (N) KafkaStatusFluent.this.withAutoRebalance(builder.build());
    }
    
    public N endAutoRebalance() {
      return and();
    }
    
  
  }

}