package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaStatusBuilder extends KafkaStatusFluent<KafkaStatusBuilder> implements VisitableBuilder<KafkaStatus,KafkaStatusBuilder>{
  public KafkaStatusBuilder() {
    this(new KafkaStatus());
  }
  
  public KafkaStatusBuilder(KafkaStatusFluent<?> fluent) {
    this(fluent, new KafkaStatus());
  }
  
  public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,KafkaStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaStatusBuilder(KafkaStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaStatusFluent<?> fluent;
  
  public KafkaStatus build() {
    KafkaStatus buildable = new KafkaStatus();
    buildable.setListeners(fluent.buildListeners());
    buildable.setKafkaNodePools(fluent.buildKafkaNodePools());
    buildable.setRegisteredNodeIds(fluent.getRegisteredNodeIds());
    buildable.setClusterId(fluent.getClusterId());
    buildable.setOperatorLastSuccessfulVersion(fluent.getOperatorLastSuccessfulVersion());
    buildable.setKafkaVersion(fluent.getKafkaVersion());
    buildable.setKafkaMetadataVersion(fluent.getKafkaMetadataVersion());
    buildable.setKafkaMetadataState(fluent.getKafkaMetadataState());
    buildable.setAutoRebalance(fluent.buildAutoRebalance());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}