package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaSpecBuilder extends KafkaSpecFluent<KafkaSpecBuilder> implements VisitableBuilder<KafkaSpec,KafkaSpecBuilder>{
  public KafkaSpecBuilder() {
    this(new KafkaSpec());
  }
  
  public KafkaSpecBuilder(KafkaSpecFluent<?> fluent) {
    this(fluent, new KafkaSpec());
  }
  
  public KafkaSpecBuilder(KafkaSpecFluent<?> fluent,KafkaSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaSpecBuilder(KafkaSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaSpecFluent<?> fluent;
  
  public KafkaSpec build() {
    KafkaSpec buildable = new KafkaSpec();
    buildable.setKafka(fluent.buildKafka());
    buildable.setZookeeper(fluent.buildZookeeper());
    buildable.setEntityOperator(fluent.buildEntityOperator());
    buildable.setClusterCa(fluent.buildClusterCa());
    buildable.setJmxTrans(fluent.buildJmxTrans());
    buildable.setKafkaExporter(fluent.buildKafkaExporter());
    buildable.setCruiseControl(fluent.buildCruiseControl());
    buildable.setClientsCa(fluent.buildClientsCa());
    buildable.setMaintenanceTimeWindows(fluent.getMaintenanceTimeWindows());
    return buildable;
  }
  

}