package io.strimzi.api.kafka.model.kafka;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaFluent<A extends KafkaFluent<A>> extends CustomResourceFluent<KafkaSpec,KafkaStatus,A>{
  public KafkaFluent() {
  }
  
  public KafkaFluent(Kafka instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private KafkaSpecBuilder spec;
  private KafkaStatusBuilder status;
  
  protected void copyInstance(Kafka instance) {
    instance = (instance != null ? instance : new Kafka());
    if (instance != null) {
          this.withSpec(instance.getSpec());
          this.withStatus(instance.getStatus());
          this.withApiVersion(instance.getApiVersion());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public KafkaSpec buildSpec() {
    return this.spec != null ? this.spec.build() : null;
  }
  
  public A withSpec(KafkaSpec spec) {
    this._visitables.remove("spec");
    if (spec != null) {
        this.spec = new KafkaSpecBuilder(spec);
        this._visitables.get("spec").add(this.spec);
    } else {
        this.spec = null;
        this._visitables.get("spec").remove(this.spec);
    }
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public SpecNested<A> withNewSpec() {
    return new SpecNested(null);
  }
  
  public SpecNested<A> withNewSpecLike(KafkaSpec item) {
    return new SpecNested(item);
  }
  
  public SpecNested<A> editSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(null));
  }
  
  public SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(new KafkaSpecBuilder().build()));
  }
  
  public SpecNested<A> editOrNewSpecLike(KafkaSpec item) {
    return withNewSpecLike(java.util.Optional.ofNullable(buildSpec()).orElse(item));
  }
  
  public KafkaStatus buildStatus() {
    return this.status != null ? this.status.build() : null;
  }
  
  public A withStatus(KafkaStatus status) {
    this._visitables.remove("status");
    if (status != null) {
        this.status = new KafkaStatusBuilder(status);
        this._visitables.get("status").add(this.status);
    } else {
        this.status = null;
        this._visitables.get("status").remove(this.status);
    }
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public StatusNested<A> withNewStatus() {
    return new StatusNested(null);
  }
  
  public StatusNested<A> withNewStatusLike(KafkaStatus item) {
    return new StatusNested(item);
  }
  
  public StatusNested<A> editStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(null));
  }
  
  public StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(new KafkaStatusBuilder().build()));
  }
  
  public StatusNested<A> editOrNewStatusLike(KafkaStatus item) {
    return withNewStatusLike(java.util.Optional.ofNullable(buildStatus()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaFluent that = (KafkaFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  spec,  status,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  public class SpecNested<N> extends KafkaSpecFluent<SpecNested<N>> implements Nested<N>{
    SpecNested(KafkaSpec item) {
      this.builder = new KafkaSpecBuilder(this, item);
    }
    KafkaSpecBuilder builder;
    
    public N and() {
      return (N) KafkaFluent.this.withSpec(builder.build());
    }
    
    public N endSpec() {
      return and();
    }
    
  
  }
  public class StatusNested<N> extends KafkaStatusFluent<StatusNested<N>> implements Nested<N>{
    StatusNested(KafkaStatus item) {
      this.builder = new KafkaStatusBuilder(this, item);
    }
    KafkaStatusBuilder builder;
    
    public N and() {
      return (N) KafkaFluent.this.withStatus(builder.build());
    }
    
    public N endStatus() {
      return and();
    }
    
  
  }

}