package io.strimzi.api.kafka.model.kafka;

import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import java.lang.String;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplate;
import java.lang.Object;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaClusterTemplateFluent<A extends KafkaClusterTemplateFluent<A>> extends BaseFluent<A>{
  public KafkaClusterTemplateFluent() {
  }
  
  public KafkaClusterTemplateFluent(KafkaClusterTemplate instance) {
    this.copyInstance(instance);
  }
  private StatefulSetTemplateBuilder statefulset;
  private ResourceTemplateBuilder podSet;
  private PodTemplateBuilder pod;
  private InternalServiceTemplateBuilder bootstrapService;
  private InternalServiceTemplateBuilder brokersService;
  private ResourceTemplateBuilder externalBootstrapService;
  private ResourceTemplateBuilder perPodService;
  private ResourceTemplateBuilder externalBootstrapRoute;
  private ResourceTemplateBuilder perPodRoute;
  private ResourceTemplateBuilder externalBootstrapIngress;
  private ResourceTemplateBuilder perPodIngress;
  private ResourceTemplateBuilder persistentVolumeClaim;
  private ResourceTemplateBuilder clusterCaCert;
  private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
  private ContainerTemplateBuilder kafkaContainer;
  private ContainerTemplateBuilder initContainer;
  private ResourceTemplateBuilder clusterRoleBinding;
  private ResourceTemplateBuilder serviceAccount;
  private ResourceTemplateBuilder jmxSecret;
  
  protected void copyInstance(KafkaClusterTemplate instance) {
    instance = (instance != null ? instance : new KafkaClusterTemplate());
    if (instance != null) {
          this.withStatefulset(instance.getStatefulset());
          this.withPodSet(instance.getPodSet());
          this.withPod(instance.getPod());
          this.withBootstrapService(instance.getBootstrapService());
          this.withBrokersService(instance.getBrokersService());
          this.withExternalBootstrapService(instance.getExternalBootstrapService());
          this.withPerPodService(instance.getPerPodService());
          this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
          this.withPerPodRoute(instance.getPerPodRoute());
          this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
          this.withPerPodIngress(instance.getPerPodIngress());
          this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
          this.withClusterCaCert(instance.getClusterCaCert());
          this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
          this.withKafkaContainer(instance.getKafkaContainer());
          this.withInitContainer(instance.getInitContainer());
          this.withClusterRoleBinding(instance.getClusterRoleBinding());
          this.withServiceAccount(instance.getServiceAccount());
          this.withJmxSecret(instance.getJmxSecret());
        }
  }
  
  public StatefulSetTemplate buildStatefulset() {
    return this.statefulset != null ? this.statefulset.build() : null;
  }
  
  public A withStatefulset(StatefulSetTemplate statefulset) {
    this._visitables.remove("statefulset");
    if (statefulset != null) {
        this.statefulset = new StatefulSetTemplateBuilder(statefulset);
        this._visitables.get("statefulset").add(this.statefulset);
    } else {
        this.statefulset = null;
        this._visitables.get("statefulset").remove(this.statefulset);
    }
    return (A) this;
  }
  
  public boolean hasStatefulset() {
    return this.statefulset != null;
  }
  
  public StatefulsetNested<A> withNewStatefulset() {
    return new StatefulsetNested(null);
  }
  
  public StatefulsetNested<A> withNewStatefulsetLike(StatefulSetTemplate item) {
    return new StatefulsetNested(item);
  }
  
  public StatefulsetNested<A> editStatefulset() {
    return withNewStatefulsetLike(java.util.Optional.ofNullable(buildStatefulset()).orElse(null));
  }
  
  public StatefulsetNested<A> editOrNewStatefulset() {
    return withNewStatefulsetLike(java.util.Optional.ofNullable(buildStatefulset()).orElse(new StatefulSetTemplateBuilder().build()));
  }
  
  public StatefulsetNested<A> editOrNewStatefulsetLike(StatefulSetTemplate item) {
    return withNewStatefulsetLike(java.util.Optional.ofNullable(buildStatefulset()).orElse(item));
  }
  
  public ResourceTemplate buildPodSet() {
    return this.podSet != null ? this.podSet.build() : null;
  }
  
  public A withPodSet(ResourceTemplate podSet) {
    this._visitables.remove("podSet");
    if (podSet != null) {
        this.podSet = new ResourceTemplateBuilder(podSet);
        this._visitables.get("podSet").add(this.podSet);
    } else {
        this.podSet = null;
        this._visitables.get("podSet").remove(this.podSet);
    }
    return (A) this;
  }
  
  public boolean hasPodSet() {
    return this.podSet != null;
  }
  
  public PodSetNested<A> withNewPodSet() {
    return new PodSetNested(null);
  }
  
  public PodSetNested<A> withNewPodSetLike(ResourceTemplate item) {
    return new PodSetNested(item);
  }
  
  public PodSetNested<A> editPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(null));
  }
  
  public PodSetNested<A> editOrNewPodSet() {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public PodSetNested<A> editOrNewPodSetLike(ResourceTemplate item) {
    return withNewPodSetLike(java.util.Optional.ofNullable(buildPodSet()).orElse(item));
  }
  
  public PodTemplate buildPod() {
    return this.pod != null ? this.pod.build() : null;
  }
  
  public A withPod(PodTemplate pod) {
    this._visitables.remove("pod");
    if (pod != null) {
        this.pod = new PodTemplateBuilder(pod);
        this._visitables.get("pod").add(this.pod);
    } else {
        this.pod = null;
        this._visitables.get("pod").remove(this.pod);
    }
    return (A) this;
  }
  
  public boolean hasPod() {
    return this.pod != null;
  }
  
  public PodNested<A> withNewPod() {
    return new PodNested(null);
  }
  
  public PodNested<A> withNewPodLike(PodTemplate item) {
    return new PodNested(item);
  }
  
  public PodNested<A> editPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(null));
  }
  
  public PodNested<A> editOrNewPod() {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(new PodTemplateBuilder().build()));
  }
  
  public PodNested<A> editOrNewPodLike(PodTemplate item) {
    return withNewPodLike(java.util.Optional.ofNullable(buildPod()).orElse(item));
  }
  
  public InternalServiceTemplate buildBootstrapService() {
    return this.bootstrapService != null ? this.bootstrapService.build() : null;
  }
  
  public A withBootstrapService(InternalServiceTemplate bootstrapService) {
    this._visitables.remove("bootstrapService");
    if (bootstrapService != null) {
        this.bootstrapService = new InternalServiceTemplateBuilder(bootstrapService);
        this._visitables.get("bootstrapService").add(this.bootstrapService);
    } else {
        this.bootstrapService = null;
        this._visitables.get("bootstrapService").remove(this.bootstrapService);
    }
    return (A) this;
  }
  
  public boolean hasBootstrapService() {
    return this.bootstrapService != null;
  }
  
  public BootstrapServiceNested<A> withNewBootstrapService() {
    return new BootstrapServiceNested(null);
  }
  
  public BootstrapServiceNested<A> withNewBootstrapServiceLike(InternalServiceTemplate item) {
    return new BootstrapServiceNested(item);
  }
  
  public BootstrapServiceNested<A> editBootstrapService() {
    return withNewBootstrapServiceLike(java.util.Optional.ofNullable(buildBootstrapService()).orElse(null));
  }
  
  public BootstrapServiceNested<A> editOrNewBootstrapService() {
    return withNewBootstrapServiceLike(java.util.Optional.ofNullable(buildBootstrapService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  
  public BootstrapServiceNested<A> editOrNewBootstrapServiceLike(InternalServiceTemplate item) {
    return withNewBootstrapServiceLike(java.util.Optional.ofNullable(buildBootstrapService()).orElse(item));
  }
  
  public InternalServiceTemplate buildBrokersService() {
    return this.brokersService != null ? this.brokersService.build() : null;
  }
  
  public A withBrokersService(InternalServiceTemplate brokersService) {
    this._visitables.remove("brokersService");
    if (brokersService != null) {
        this.brokersService = new InternalServiceTemplateBuilder(brokersService);
        this._visitables.get("brokersService").add(this.brokersService);
    } else {
        this.brokersService = null;
        this._visitables.get("brokersService").remove(this.brokersService);
    }
    return (A) this;
  }
  
  public boolean hasBrokersService() {
    return this.brokersService != null;
  }
  
  public BrokersServiceNested<A> withNewBrokersService() {
    return new BrokersServiceNested(null);
  }
  
  public BrokersServiceNested<A> withNewBrokersServiceLike(InternalServiceTemplate item) {
    return new BrokersServiceNested(item);
  }
  
  public BrokersServiceNested<A> editBrokersService() {
    return withNewBrokersServiceLike(java.util.Optional.ofNullable(buildBrokersService()).orElse(null));
  }
  
  public BrokersServiceNested<A> editOrNewBrokersService() {
    return withNewBrokersServiceLike(java.util.Optional.ofNullable(buildBrokersService()).orElse(new InternalServiceTemplateBuilder().build()));
  }
  
  public BrokersServiceNested<A> editOrNewBrokersServiceLike(InternalServiceTemplate item) {
    return withNewBrokersServiceLike(java.util.Optional.ofNullable(buildBrokersService()).orElse(item));
  }
  
  public ResourceTemplate buildExternalBootstrapService() {
    return this.externalBootstrapService != null ? this.externalBootstrapService.build() : null;
  }
  
  public A withExternalBootstrapService(ResourceTemplate externalBootstrapService) {
    this._visitables.remove("externalBootstrapService");
    if (externalBootstrapService != null) {
        this.externalBootstrapService = new ResourceTemplateBuilder(externalBootstrapService);
        this._visitables.get("externalBootstrapService").add(this.externalBootstrapService);
    } else {
        this.externalBootstrapService = null;
        this._visitables.get("externalBootstrapService").remove(this.externalBootstrapService);
    }
    return (A) this;
  }
  
  public boolean hasExternalBootstrapService() {
    return this.externalBootstrapService != null;
  }
  
  public ExternalBootstrapServiceNested<A> withNewExternalBootstrapService() {
    return new ExternalBootstrapServiceNested(null);
  }
  
  public ExternalBootstrapServiceNested<A> withNewExternalBootstrapServiceLike(ResourceTemplate item) {
    return new ExternalBootstrapServiceNested(item);
  }
  
  public ExternalBootstrapServiceNested<A> editExternalBootstrapService() {
    return withNewExternalBootstrapServiceLike(java.util.Optional.ofNullable(buildExternalBootstrapService()).orElse(null));
  }
  
  public ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapService() {
    return withNewExternalBootstrapServiceLike(java.util.Optional.ofNullable(buildExternalBootstrapService()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapServiceLike(ResourceTemplate item) {
    return withNewExternalBootstrapServiceLike(java.util.Optional.ofNullable(buildExternalBootstrapService()).orElse(item));
  }
  
  public ResourceTemplate buildPerPodService() {
    return this.perPodService != null ? this.perPodService.build() : null;
  }
  
  public A withPerPodService(ResourceTemplate perPodService) {
    this._visitables.remove("perPodService");
    if (perPodService != null) {
        this.perPodService = new ResourceTemplateBuilder(perPodService);
        this._visitables.get("perPodService").add(this.perPodService);
    } else {
        this.perPodService = null;
        this._visitables.get("perPodService").remove(this.perPodService);
    }
    return (A) this;
  }
  
  public boolean hasPerPodService() {
    return this.perPodService != null;
  }
  
  public PerPodServiceNested<A> withNewPerPodService() {
    return new PerPodServiceNested(null);
  }
  
  public PerPodServiceNested<A> withNewPerPodServiceLike(ResourceTemplate item) {
    return new PerPodServiceNested(item);
  }
  
  public PerPodServiceNested<A> editPerPodService() {
    return withNewPerPodServiceLike(java.util.Optional.ofNullable(buildPerPodService()).orElse(null));
  }
  
  public PerPodServiceNested<A> editOrNewPerPodService() {
    return withNewPerPodServiceLike(java.util.Optional.ofNullable(buildPerPodService()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public PerPodServiceNested<A> editOrNewPerPodServiceLike(ResourceTemplate item) {
    return withNewPerPodServiceLike(java.util.Optional.ofNullable(buildPerPodService()).orElse(item));
  }
  
  public ResourceTemplate buildExternalBootstrapRoute() {
    return this.externalBootstrapRoute != null ? this.externalBootstrapRoute.build() : null;
  }
  
  public A withExternalBootstrapRoute(ResourceTemplate externalBootstrapRoute) {
    this._visitables.remove("externalBootstrapRoute");
    if (externalBootstrapRoute != null) {
        this.externalBootstrapRoute = new ResourceTemplateBuilder(externalBootstrapRoute);
        this._visitables.get("externalBootstrapRoute").add(this.externalBootstrapRoute);
    } else {
        this.externalBootstrapRoute = null;
        this._visitables.get("externalBootstrapRoute").remove(this.externalBootstrapRoute);
    }
    return (A) this;
  }
  
  public boolean hasExternalBootstrapRoute() {
    return this.externalBootstrapRoute != null;
  }
  
  public ExternalBootstrapRouteNested<A> withNewExternalBootstrapRoute() {
    return new ExternalBootstrapRouteNested(null);
  }
  
  public ExternalBootstrapRouteNested<A> withNewExternalBootstrapRouteLike(ResourceTemplate item) {
    return new ExternalBootstrapRouteNested(item);
  }
  
  public ExternalBootstrapRouteNested<A> editExternalBootstrapRoute() {
    return withNewExternalBootstrapRouteLike(java.util.Optional.ofNullable(buildExternalBootstrapRoute()).orElse(null));
  }
  
  public ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRoute() {
    return withNewExternalBootstrapRouteLike(java.util.Optional.ofNullable(buildExternalBootstrapRoute()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRouteLike(ResourceTemplate item) {
    return withNewExternalBootstrapRouteLike(java.util.Optional.ofNullable(buildExternalBootstrapRoute()).orElse(item));
  }
  
  public ResourceTemplate buildPerPodRoute() {
    return this.perPodRoute != null ? this.perPodRoute.build() : null;
  }
  
  public A withPerPodRoute(ResourceTemplate perPodRoute) {
    this._visitables.remove("perPodRoute");
    if (perPodRoute != null) {
        this.perPodRoute = new ResourceTemplateBuilder(perPodRoute);
        this._visitables.get("perPodRoute").add(this.perPodRoute);
    } else {
        this.perPodRoute = null;
        this._visitables.get("perPodRoute").remove(this.perPodRoute);
    }
    return (A) this;
  }
  
  public boolean hasPerPodRoute() {
    return this.perPodRoute != null;
  }
  
  public PerPodRouteNested<A> withNewPerPodRoute() {
    return new PerPodRouteNested(null);
  }
  
  public PerPodRouteNested<A> withNewPerPodRouteLike(ResourceTemplate item) {
    return new PerPodRouteNested(item);
  }
  
  public PerPodRouteNested<A> editPerPodRoute() {
    return withNewPerPodRouteLike(java.util.Optional.ofNullable(buildPerPodRoute()).orElse(null));
  }
  
  public PerPodRouteNested<A> editOrNewPerPodRoute() {
    return withNewPerPodRouteLike(java.util.Optional.ofNullable(buildPerPodRoute()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public PerPodRouteNested<A> editOrNewPerPodRouteLike(ResourceTemplate item) {
    return withNewPerPodRouteLike(java.util.Optional.ofNullable(buildPerPodRoute()).orElse(item));
  }
  
  public ResourceTemplate buildExternalBootstrapIngress() {
    return this.externalBootstrapIngress != null ? this.externalBootstrapIngress.build() : null;
  }
  
  public A withExternalBootstrapIngress(ResourceTemplate externalBootstrapIngress) {
    this._visitables.remove("externalBootstrapIngress");
    if (externalBootstrapIngress != null) {
        this.externalBootstrapIngress = new ResourceTemplateBuilder(externalBootstrapIngress);
        this._visitables.get("externalBootstrapIngress").add(this.externalBootstrapIngress);
    } else {
        this.externalBootstrapIngress = null;
        this._visitables.get("externalBootstrapIngress").remove(this.externalBootstrapIngress);
    }
    return (A) this;
  }
  
  public boolean hasExternalBootstrapIngress() {
    return this.externalBootstrapIngress != null;
  }
  
  public ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngress() {
    return new ExternalBootstrapIngressNested(null);
  }
  
  public ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngressLike(ResourceTemplate item) {
    return new ExternalBootstrapIngressNested(item);
  }
  
  public ExternalBootstrapIngressNested<A> editExternalBootstrapIngress() {
    return withNewExternalBootstrapIngressLike(java.util.Optional.ofNullable(buildExternalBootstrapIngress()).orElse(null));
  }
  
  public ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngress() {
    return withNewExternalBootstrapIngressLike(java.util.Optional.ofNullable(buildExternalBootstrapIngress()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngressLike(ResourceTemplate item) {
    return withNewExternalBootstrapIngressLike(java.util.Optional.ofNullable(buildExternalBootstrapIngress()).orElse(item));
  }
  
  public ResourceTemplate buildPerPodIngress() {
    return this.perPodIngress != null ? this.perPodIngress.build() : null;
  }
  
  public A withPerPodIngress(ResourceTemplate perPodIngress) {
    this._visitables.remove("perPodIngress");
    if (perPodIngress != null) {
        this.perPodIngress = new ResourceTemplateBuilder(perPodIngress);
        this._visitables.get("perPodIngress").add(this.perPodIngress);
    } else {
        this.perPodIngress = null;
        this._visitables.get("perPodIngress").remove(this.perPodIngress);
    }
    return (A) this;
  }
  
  public boolean hasPerPodIngress() {
    return this.perPodIngress != null;
  }
  
  public PerPodIngressNested<A> withNewPerPodIngress() {
    return new PerPodIngressNested(null);
  }
  
  public PerPodIngressNested<A> withNewPerPodIngressLike(ResourceTemplate item) {
    return new PerPodIngressNested(item);
  }
  
  public PerPodIngressNested<A> editPerPodIngress() {
    return withNewPerPodIngressLike(java.util.Optional.ofNullable(buildPerPodIngress()).orElse(null));
  }
  
  public PerPodIngressNested<A> editOrNewPerPodIngress() {
    return withNewPerPodIngressLike(java.util.Optional.ofNullable(buildPerPodIngress()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public PerPodIngressNested<A> editOrNewPerPodIngressLike(ResourceTemplate item) {
    return withNewPerPodIngressLike(java.util.Optional.ofNullable(buildPerPodIngress()).orElse(item));
  }
  
  public ResourceTemplate buildPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null ? this.persistentVolumeClaim.build() : null;
  }
  
  public A withPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
    this._visitables.remove("persistentVolumeClaim");
    if (persistentVolumeClaim != null) {
        this.persistentVolumeClaim = new ResourceTemplateBuilder(persistentVolumeClaim);
        this._visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);
    } else {
        this.persistentVolumeClaim = null;
        this._visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
    }
    return (A) this;
  }
  
  public boolean hasPersistentVolumeClaim() {
    return this.persistentVolumeClaim != null;
  }
  
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
    return new PersistentVolumeClaimNested(null);
  }
  
  public PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(ResourceTemplate item) {
    return new PersistentVolumeClaimNested(item);
  }
  
  public PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(null));
  }
  
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(ResourceTemplate item) {
    return withNewPersistentVolumeClaimLike(java.util.Optional.ofNullable(buildPersistentVolumeClaim()).orElse(item));
  }
  
  public ResourceTemplate buildClusterCaCert() {
    return this.clusterCaCert != null ? this.clusterCaCert.build() : null;
  }
  
  public A withClusterCaCert(ResourceTemplate clusterCaCert) {
    this._visitables.remove("clusterCaCert");
    if (clusterCaCert != null) {
        this.clusterCaCert = new ResourceTemplateBuilder(clusterCaCert);
        this._visitables.get("clusterCaCert").add(this.clusterCaCert);
    } else {
        this.clusterCaCert = null;
        this._visitables.get("clusterCaCert").remove(this.clusterCaCert);
    }
    return (A) this;
  }
  
  public boolean hasClusterCaCert() {
    return this.clusterCaCert != null;
  }
  
  public ClusterCaCertNested<A> withNewClusterCaCert() {
    return new ClusterCaCertNested(null);
  }
  
  public ClusterCaCertNested<A> withNewClusterCaCertLike(ResourceTemplate item) {
    return new ClusterCaCertNested(item);
  }
  
  public ClusterCaCertNested<A> editClusterCaCert() {
    return withNewClusterCaCertLike(java.util.Optional.ofNullable(buildClusterCaCert()).orElse(null));
  }
  
  public ClusterCaCertNested<A> editOrNewClusterCaCert() {
    return withNewClusterCaCertLike(java.util.Optional.ofNullable(buildClusterCaCert()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ClusterCaCertNested<A> editOrNewClusterCaCertLike(ResourceTemplate item) {
    return withNewClusterCaCertLike(java.util.Optional.ofNullable(buildClusterCaCert()).orElse(item));
  }
  
  public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
    return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
  }
  
  public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
    this._visitables.remove("podDisruptionBudget");
    if (podDisruptionBudget != null) {
        this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
        this._visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);
    } else {
        this.podDisruptionBudget = null;
        this._visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
    }
    return (A) this;
  }
  
  public boolean hasPodDisruptionBudget() {
    return this.podDisruptionBudget != null;
  }
  
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
    return new PodDisruptionBudgetNested(null);
  }
  
  public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return new PodDisruptionBudgetNested(item);
  }
  
  public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(null));
  }
  
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
  }
  
  public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
    return withNewPodDisruptionBudgetLike(java.util.Optional.ofNullable(buildPodDisruptionBudget()).orElse(item));
  }
  
  public ContainerTemplate buildKafkaContainer() {
    return this.kafkaContainer != null ? this.kafkaContainer.build() : null;
  }
  
  public A withKafkaContainer(ContainerTemplate kafkaContainer) {
    this._visitables.remove("kafkaContainer");
    if (kafkaContainer != null) {
        this.kafkaContainer = new ContainerTemplateBuilder(kafkaContainer);
        this._visitables.get("kafkaContainer").add(this.kafkaContainer);
    } else {
        this.kafkaContainer = null;
        this._visitables.get("kafkaContainer").remove(this.kafkaContainer);
    }
    return (A) this;
  }
  
  public boolean hasKafkaContainer() {
    return this.kafkaContainer != null;
  }
  
  public KafkaContainerNested<A> withNewKafkaContainer() {
    return new KafkaContainerNested(null);
  }
  
  public KafkaContainerNested<A> withNewKafkaContainerLike(ContainerTemplate item) {
    return new KafkaContainerNested(item);
  }
  
  public KafkaContainerNested<A> editKafkaContainer() {
    return withNewKafkaContainerLike(java.util.Optional.ofNullable(buildKafkaContainer()).orElse(null));
  }
  
  public KafkaContainerNested<A> editOrNewKafkaContainer() {
    return withNewKafkaContainerLike(java.util.Optional.ofNullable(buildKafkaContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  
  public KafkaContainerNested<A> editOrNewKafkaContainerLike(ContainerTemplate item) {
    return withNewKafkaContainerLike(java.util.Optional.ofNullable(buildKafkaContainer()).orElse(item));
  }
  
  public ContainerTemplate buildInitContainer() {
    return this.initContainer != null ? this.initContainer.build() : null;
  }
  
  public A withInitContainer(ContainerTemplate initContainer) {
    this._visitables.remove("initContainer");
    if (initContainer != null) {
        this.initContainer = new ContainerTemplateBuilder(initContainer);
        this._visitables.get("initContainer").add(this.initContainer);
    } else {
        this.initContainer = null;
        this._visitables.get("initContainer").remove(this.initContainer);
    }
    return (A) this;
  }
  
  public boolean hasInitContainer() {
    return this.initContainer != null;
  }
  
  public InitContainerNested<A> withNewInitContainer() {
    return new InitContainerNested(null);
  }
  
  public InitContainerNested<A> withNewInitContainerLike(ContainerTemplate item) {
    return new InitContainerNested(item);
  }
  
  public InitContainerNested<A> editInitContainer() {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(null));
  }
  
  public InitContainerNested<A> editOrNewInitContainer() {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(new ContainerTemplateBuilder().build()));
  }
  
  public InitContainerNested<A> editOrNewInitContainerLike(ContainerTemplate item) {
    return withNewInitContainerLike(java.util.Optional.ofNullable(buildInitContainer()).orElse(item));
  }
  
  public ResourceTemplate buildClusterRoleBinding() {
    return this.clusterRoleBinding != null ? this.clusterRoleBinding.build() : null;
  }
  
  public A withClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
    this._visitables.remove("clusterRoleBinding");
    if (clusterRoleBinding != null) {
        this.clusterRoleBinding = new ResourceTemplateBuilder(clusterRoleBinding);
        this._visitables.get("clusterRoleBinding").add(this.clusterRoleBinding);
    } else {
        this.clusterRoleBinding = null;
        this._visitables.get("clusterRoleBinding").remove(this.clusterRoleBinding);
    }
    return (A) this;
  }
  
  public boolean hasClusterRoleBinding() {
    return this.clusterRoleBinding != null;
  }
  
  public ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
    return new ClusterRoleBindingNested(null);
  }
  
  public ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(ResourceTemplate item) {
    return new ClusterRoleBindingNested(item);
  }
  
  public ClusterRoleBindingNested<A> editClusterRoleBinding() {
    return withNewClusterRoleBindingLike(java.util.Optional.ofNullable(buildClusterRoleBinding()).orElse(null));
  }
  
  public ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
    return withNewClusterRoleBindingLike(java.util.Optional.ofNullable(buildClusterRoleBinding()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(ResourceTemplate item) {
    return withNewClusterRoleBindingLike(java.util.Optional.ofNullable(buildClusterRoleBinding()).orElse(item));
  }
  
  public ResourceTemplate buildServiceAccount() {
    return this.serviceAccount != null ? this.serviceAccount.build() : null;
  }
  
  public A withServiceAccount(ResourceTemplate serviceAccount) {
    this._visitables.remove("serviceAccount");
    if (serviceAccount != null) {
        this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
        this._visitables.get("serviceAccount").add(this.serviceAccount);
    } else {
        this.serviceAccount = null;
        this._visitables.get("serviceAccount").remove(this.serviceAccount);
    }
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public ServiceAccountNested<A> withNewServiceAccount() {
    return new ServiceAccountNested(null);
  }
  
  public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
    return new ServiceAccountNested(item);
  }
  
  public ServiceAccountNested<A> editServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(null));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccount() {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
    return withNewServiceAccountLike(java.util.Optional.ofNullable(buildServiceAccount()).orElse(item));
  }
  
  public ResourceTemplate buildJmxSecret() {
    return this.jmxSecret != null ? this.jmxSecret.build() : null;
  }
  
  public A withJmxSecret(ResourceTemplate jmxSecret) {
    this._visitables.remove("jmxSecret");
    if (jmxSecret != null) {
        this.jmxSecret = new ResourceTemplateBuilder(jmxSecret);
        this._visitables.get("jmxSecret").add(this.jmxSecret);
    } else {
        this.jmxSecret = null;
        this._visitables.get("jmxSecret").remove(this.jmxSecret);
    }
    return (A) this;
  }
  
  public boolean hasJmxSecret() {
    return this.jmxSecret != null;
  }
  
  public JmxSecretNested<A> withNewJmxSecret() {
    return new JmxSecretNested(null);
  }
  
  public JmxSecretNested<A> withNewJmxSecretLike(ResourceTemplate item) {
    return new JmxSecretNested(item);
  }
  
  public JmxSecretNested<A> editJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(null));
  }
  
  public JmxSecretNested<A> editOrNewJmxSecret() {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(new ResourceTemplateBuilder().build()));
  }
  
  public JmxSecretNested<A> editOrNewJmxSecretLike(ResourceTemplate item) {
    return withNewJmxSecretLike(java.util.Optional.ofNullable(buildJmxSecret()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaClusterTemplateFluent that = (KafkaClusterTemplateFluent) o;
    if (!java.util.Objects.equals(statefulset, that.statefulset)) return false;
    if (!java.util.Objects.equals(podSet, that.podSet)) return false;
    if (!java.util.Objects.equals(pod, that.pod)) return false;
    if (!java.util.Objects.equals(bootstrapService, that.bootstrapService)) return false;
    if (!java.util.Objects.equals(brokersService, that.brokersService)) return false;
    if (!java.util.Objects.equals(externalBootstrapService, that.externalBootstrapService)) return false;
    if (!java.util.Objects.equals(perPodService, that.perPodService)) return false;
    if (!java.util.Objects.equals(externalBootstrapRoute, that.externalBootstrapRoute)) return false;
    if (!java.util.Objects.equals(perPodRoute, that.perPodRoute)) return false;
    if (!java.util.Objects.equals(externalBootstrapIngress, that.externalBootstrapIngress)) return false;
    if (!java.util.Objects.equals(perPodIngress, that.perPodIngress)) return false;
    if (!java.util.Objects.equals(persistentVolumeClaim, that.persistentVolumeClaim)) return false;
    if (!java.util.Objects.equals(clusterCaCert, that.clusterCaCert)) return false;
    if (!java.util.Objects.equals(podDisruptionBudget, that.podDisruptionBudget)) return false;
    if (!java.util.Objects.equals(kafkaContainer, that.kafkaContainer)) return false;
    if (!java.util.Objects.equals(initContainer, that.initContainer)) return false;
    if (!java.util.Objects.equals(clusterRoleBinding, that.clusterRoleBinding)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(jmxSecret, that.jmxSecret)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(statefulset,  podSet,  pod,  bootstrapService,  brokersService,  externalBootstrapService,  perPodService,  externalBootstrapRoute,  perPodRoute,  externalBootstrapIngress,  perPodIngress,  persistentVolumeClaim,  clusterCaCert,  podDisruptionBudget,  kafkaContainer,  initContainer,  clusterRoleBinding,  serviceAccount,  jmxSecret,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (statefulset != null) { sb.append("statefulset:"); sb.append(statefulset + ","); }
    if (podSet != null) { sb.append("podSet:"); sb.append(podSet + ","); }
    if (pod != null) { sb.append("pod:"); sb.append(pod + ","); }
    if (bootstrapService != null) { sb.append("bootstrapService:"); sb.append(bootstrapService + ","); }
    if (brokersService != null) { sb.append("brokersService:"); sb.append(brokersService + ","); }
    if (externalBootstrapService != null) { sb.append("externalBootstrapService:"); sb.append(externalBootstrapService + ","); }
    if (perPodService != null) { sb.append("perPodService:"); sb.append(perPodService + ","); }
    if (externalBootstrapRoute != null) { sb.append("externalBootstrapRoute:"); sb.append(externalBootstrapRoute + ","); }
    if (perPodRoute != null) { sb.append("perPodRoute:"); sb.append(perPodRoute + ","); }
    if (externalBootstrapIngress != null) { sb.append("externalBootstrapIngress:"); sb.append(externalBootstrapIngress + ","); }
    if (perPodIngress != null) { sb.append("perPodIngress:"); sb.append(perPodIngress + ","); }
    if (persistentVolumeClaim != null) { sb.append("persistentVolumeClaim:"); sb.append(persistentVolumeClaim + ","); }
    if (clusterCaCert != null) { sb.append("clusterCaCert:"); sb.append(clusterCaCert + ","); }
    if (podDisruptionBudget != null) { sb.append("podDisruptionBudget:"); sb.append(podDisruptionBudget + ","); }
    if (kafkaContainer != null) { sb.append("kafkaContainer:"); sb.append(kafkaContainer + ","); }
    if (initContainer != null) { sb.append("initContainer:"); sb.append(initContainer + ","); }
    if (clusterRoleBinding != null) { sb.append("clusterRoleBinding:"); sb.append(clusterRoleBinding + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (jmxSecret != null) { sb.append("jmxSecret:"); sb.append(jmxSecret); }
    sb.append("}");
    return sb.toString();
  }
  public class StatefulsetNested<N> extends StatefulSetTemplateFluent<StatefulsetNested<N>> implements Nested<N>{
    StatefulsetNested(StatefulSetTemplate item) {
      this.builder = new StatefulSetTemplateBuilder(this, item);
    }
    StatefulSetTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withStatefulset(builder.build());
    }
    
    public N endStatefulset() {
      return and();
    }
    
  
  }
  public class PodSetNested<N> extends ResourceTemplateFluent<PodSetNested<N>> implements Nested<N>{
    PodSetNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPodSet(builder.build());
    }
    
    public N endPodSet() {
      return and();
    }
    
  
  }
  public class PodNested<N> extends PodTemplateFluent<PodNested<N>> implements Nested<N>{
    PodNested(PodTemplate item) {
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPod(builder.build());
    }
    
    public N endPod() {
      return and();
    }
    
  
  }
  public class BootstrapServiceNested<N> extends InternalServiceTemplateFluent<BootstrapServiceNested<N>> implements Nested<N>{
    BootstrapServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withBootstrapService(builder.build());
    }
    
    public N endBootstrapService() {
      return and();
    }
    
  
  }
  public class BrokersServiceNested<N> extends InternalServiceTemplateFluent<BrokersServiceNested<N>> implements Nested<N>{
    BrokersServiceNested(InternalServiceTemplate item) {
      this.builder = new InternalServiceTemplateBuilder(this, item);
    }
    InternalServiceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withBrokersService(builder.build());
    }
    
    public N endBrokersService() {
      return and();
    }
    
  
  }
  public class ExternalBootstrapServiceNested<N> extends ResourceTemplateFluent<ExternalBootstrapServiceNested<N>> implements Nested<N>{
    ExternalBootstrapServiceNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withExternalBootstrapService(builder.build());
    }
    
    public N endExternalBootstrapService() {
      return and();
    }
    
  
  }
  public class PerPodServiceNested<N> extends ResourceTemplateFluent<PerPodServiceNested<N>> implements Nested<N>{
    PerPodServiceNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPerPodService(builder.build());
    }
    
    public N endPerPodService() {
      return and();
    }
    
  
  }
  public class ExternalBootstrapRouteNested<N> extends ResourceTemplateFluent<ExternalBootstrapRouteNested<N>> implements Nested<N>{
    ExternalBootstrapRouteNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withExternalBootstrapRoute(builder.build());
    }
    
    public N endExternalBootstrapRoute() {
      return and();
    }
    
  
  }
  public class PerPodRouteNested<N> extends ResourceTemplateFluent<PerPodRouteNested<N>> implements Nested<N>{
    PerPodRouteNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPerPodRoute(builder.build());
    }
    
    public N endPerPodRoute() {
      return and();
    }
    
  
  }
  public class ExternalBootstrapIngressNested<N> extends ResourceTemplateFluent<ExternalBootstrapIngressNested<N>> implements Nested<N>{
    ExternalBootstrapIngressNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withExternalBootstrapIngress(builder.build());
    }
    
    public N endExternalBootstrapIngress() {
      return and();
    }
    
  
  }
  public class PerPodIngressNested<N> extends ResourceTemplateFluent<PerPodIngressNested<N>> implements Nested<N>{
    PerPodIngressNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPerPodIngress(builder.build());
    }
    
    public N endPerPodIngress() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimNested<N> extends ResourceTemplateFluent<PersistentVolumeClaimNested<N>> implements Nested<N>{
    PersistentVolumeClaimNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPersistentVolumeClaim(builder.build());
    }
    
    public N endPersistentVolumeClaim() {
      return and();
    }
    
  
  }
  public class ClusterCaCertNested<N> extends ResourceTemplateFluent<ClusterCaCertNested<N>> implements Nested<N>{
    ClusterCaCertNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withClusterCaCert(builder.build());
    }
    
    public N endClusterCaCert() {
      return and();
    }
    
  
  }
  public class PodDisruptionBudgetNested<N> extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>> implements Nested<N>{
    PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
      this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
    }
    PodDisruptionBudgetTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withPodDisruptionBudget(builder.build());
    }
    
    public N endPodDisruptionBudget() {
      return and();
    }
    
  
  }
  public class KafkaContainerNested<N> extends ContainerTemplateFluent<KafkaContainerNested<N>> implements Nested<N>{
    KafkaContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withKafkaContainer(builder.build());
    }
    
    public N endKafkaContainer() {
      return and();
    }
    
  
  }
  public class InitContainerNested<N> extends ContainerTemplateFluent<InitContainerNested<N>> implements Nested<N>{
    InitContainerNested(ContainerTemplate item) {
      this.builder = new ContainerTemplateBuilder(this, item);
    }
    ContainerTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withInitContainer(builder.build());
    }
    
    public N endInitContainer() {
      return and();
    }
    
  
  }
  public class ClusterRoleBindingNested<N> extends ResourceTemplateFluent<ClusterRoleBindingNested<N>> implements Nested<N>{
    ClusterRoleBindingNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withClusterRoleBinding(builder.build());
    }
    
    public N endClusterRoleBinding() {
      return and();
    }
    
  
  }
  public class ServiceAccountNested<N> extends ResourceTemplateFluent<ServiceAccountNested<N>> implements Nested<N>{
    ServiceAccountNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withServiceAccount(builder.build());
    }
    
    public N endServiceAccount() {
      return and();
    }
    
  
  }
  public class JmxSecretNested<N> extends ResourceTemplateFluent<JmxSecretNested<N>> implements Nested<N>{
    JmxSecretNested(ResourceTemplate item) {
      this.builder = new ResourceTemplateBuilder(this, item);
    }
    ResourceTemplateBuilder builder;
    
    public N and() {
      return (N) KafkaClusterTemplateFluent.this.withJmxSecret(builder.build());
    }
    
    public N endJmxSecret() {
      return and();
    }
    
  
  }

}