package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaClusterTemplateBuilder extends KafkaClusterTemplateFluent<KafkaClusterTemplateBuilder> implements VisitableBuilder<KafkaClusterTemplate,KafkaClusterTemplateBuilder>{
  public KafkaClusterTemplateBuilder() {
    this(new KafkaClusterTemplate());
  }
  
  public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent) {
    this(fluent, new KafkaClusterTemplate());
  }
  
  public KafkaClusterTemplateBuilder(KafkaClusterTemplateFluent<?> fluent,KafkaClusterTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaClusterTemplateBuilder(KafkaClusterTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaClusterTemplateFluent<?> fluent;
  
  public KafkaClusterTemplate build() {
    KafkaClusterTemplate buildable = new KafkaClusterTemplate();
    buildable.setStatefulset(fluent.buildStatefulset());
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setBootstrapService(fluent.buildBootstrapService());
    buildable.setBrokersService(fluent.buildBrokersService());
    buildable.setExternalBootstrapService(fluent.buildExternalBootstrapService());
    buildable.setPerPodService(fluent.buildPerPodService());
    buildable.setExternalBootstrapRoute(fluent.buildExternalBootstrapRoute());
    buildable.setPerPodRoute(fluent.buildPerPodRoute());
    buildable.setExternalBootstrapIngress(fluent.buildExternalBootstrapIngress());
    buildable.setPerPodIngress(fluent.buildPerPodIngress());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setClusterCaCert(fluent.buildClusterCaCert());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setKafkaContainer(fluent.buildKafkaContainer());
    buildable.setInitContainer(fluent.buildInitContainer());
    buildable.setClusterRoleBinding(fluent.buildClusterRoleBinding());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  

}