package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaClusterSpecBuilder extends KafkaClusterSpecFluent<KafkaClusterSpecBuilder> implements VisitableBuilder<KafkaClusterSpec,KafkaClusterSpecBuilder>{
  public KafkaClusterSpecBuilder() {
    this(new KafkaClusterSpec());
  }
  
  public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent) {
    this(fluent, new KafkaClusterSpec());
  }
  
  public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,KafkaClusterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaClusterSpecBuilder(KafkaClusterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaClusterSpecFluent<?> fluent;
  
  public KafkaClusterSpec build() {
    KafkaClusterSpec buildable = new KafkaClusterSpec();
    buildable.setStorage(fluent.buildStorage());
    buildable.setVersion(fluent.getVersion());
    buildable.setMetadataVersion(fluent.getMetadataVersion());
    buildable.setConfig(fluent.getConfig());
    buildable.setBrokerRackInitImage(fluent.getBrokerRackInitImage());
    buildable.setRack(fluent.buildRack());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setListeners(fluent.buildListeners());
    buildable.setAuthorization(fluent.buildAuthorization());
    buildable.setTemplate(fluent.buildTemplate());
    buildable.setTieredStorage(fluent.buildTieredStorage());
    buildable.setQuotas(fluent.buildQuotas());
    return buildable;
  }
  

}