package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaBuilder extends KafkaFluent<KafkaBuilder> implements VisitableBuilder<Kafka,KafkaBuilder>{
  public KafkaBuilder() {
    this(new Kafka());
  }
  
  public KafkaBuilder(KafkaFluent<?> fluent) {
    this(fluent, new Kafka());
  }
  
  public KafkaBuilder(KafkaFluent<?> fluent,Kafka instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaBuilder(Kafka instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaFluent<?> fluent;
  
  public Kafka build() {
    Kafka buildable = new Kafka(fluent.buildSpec(),fluent.buildStatus());
    buildable.setApiVersion(fluent.getApiVersion());
    buildable.setKind(fluent.getKind());
    buildable.setMetadata(fluent.buildMetadata());
    return buildable;
  }
  

}