package io.strimzi.api.kafka.model.kafka;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaAuthorizationSimpleFluent<A extends KafkaAuthorizationSimpleFluent<A>> extends BaseFluent<A>{
  public KafkaAuthorizationSimpleFluent() {
  }
  
  public KafkaAuthorizationSimpleFluent(KafkaAuthorizationSimple instance) {
    this.copyInstance(instance);
  }
  private List<String> superUsers;
  
  protected void copyInstance(KafkaAuthorizationSimple instance) {
    instance = (instance != null ? instance : new KafkaAuthorizationSimple());
    if (instance != null) {
          this.withSuperUsers(instance.getSuperUsers());
        }
  }
  
  public A addToSuperUsers(int index,String item) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    this.superUsers.add(index, item);
    return (A)this;
  }
  
  public A setToSuperUsers(int index,String item) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    this.superUsers.set(index, item); return (A)this;
  }
  
  public A addToSuperUsers(java.lang.String... items) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    for (String item : items) {this.superUsers.add(item);} return (A)this;
  }
  
  public A addAllToSuperUsers(Collection<String> items) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    for (String item : items) {this.superUsers.add(item);} return (A)this;
  }
  
  public A removeFromSuperUsers(java.lang.String... items) {
    if (this.superUsers == null) return (A)this;
    for (String item : items) { this.superUsers.remove(item);} return (A)this;
  }
  
  public A removeAllFromSuperUsers(Collection<String> items) {
    if (this.superUsers == null) return (A)this;
    for (String item : items) { this.superUsers.remove(item);} return (A)this;
  }
  
  public List<String> getSuperUsers() {
    return this.superUsers;
  }
  
  public String getSuperUser(int index) {
    return this.superUsers.get(index);
  }
  
  public String getFirstSuperUser() {
    return this.superUsers.get(0);
  }
  
  public String getLastSuperUser() {
    return this.superUsers.get(superUsers.size() - 1);
  }
  
  public String getMatchingSuperUser(Predicate<String> predicate) {
      for (String item : superUsers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSuperUser(Predicate<String> predicate) {
      for (String item : superUsers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSuperUsers(List<String> superUsers) {
    if (superUsers != null) {
        this.superUsers = new ArrayList();
        for (String item : superUsers) {
          this.addToSuperUsers(item);
        }
    } else {
      this.superUsers = null;
    }
    return (A) this;
  }
  
  public A withSuperUsers(java.lang.String... superUsers) {
    if (this.superUsers != null) {
        this.superUsers.clear();
        _visitables.remove("superUsers");
    }
    if (superUsers != null) {
      for (String item : superUsers) {
        this.addToSuperUsers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSuperUsers() {
    return this.superUsers != null && !this.superUsers.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaAuthorizationSimpleFluent that = (KafkaAuthorizationSimpleFluent) o;
    if (!java.util.Objects.equals(superUsers, that.superUsers)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(superUsers,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (superUsers != null && !superUsers.isEmpty()) { sb.append("superUsers:"); sb.append(superUsers); }
    sb.append("}");
    return sb.toString();
  }
  

}