package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSourceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.strimzi.api.kafka.model.common.CertSecretSource;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KafkaAuthorizationOpaFluent<A extends KafkaAuthorizationOpaFluent<A>> extends BaseFluent<A>{
  public KafkaAuthorizationOpaFluent() {
  }
  
  public KafkaAuthorizationOpaFluent(KafkaAuthorizationOpa instance) {
    this.copyInstance(instance);
  }
  private List<String> superUsers;
  private String url;
  private boolean allowOnError;
  private int initialCacheCapacity;
  private int maximumCacheSize;
  private long expireAfterMs;
  private boolean enableMetrics;
  private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
  
  protected void copyInstance(KafkaAuthorizationOpa instance) {
    instance = (instance != null ? instance : new KafkaAuthorizationOpa());
    if (instance != null) {
          this.withSuperUsers(instance.getSuperUsers());
          this.withUrl(instance.getUrl());
          this.withAllowOnError(instance.isAllowOnError());
          this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
          this.withMaximumCacheSize(instance.getMaximumCacheSize());
          this.withExpireAfterMs(instance.getExpireAfterMs());
          this.withEnableMetrics(instance.isEnableMetrics());
          this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        }
  }
  
  public A addToSuperUsers(int index,String item) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    this.superUsers.add(index, item);
    return (A)this;
  }
  
  public A setToSuperUsers(int index,String item) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    this.superUsers.set(index, item); return (A)this;
  }
  
  public A addToSuperUsers(java.lang.String... items) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    for (String item : items) {this.superUsers.add(item);} return (A)this;
  }
  
  public A addAllToSuperUsers(Collection<String> items) {
    if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
    for (String item : items) {this.superUsers.add(item);} return (A)this;
  }
  
  public A removeFromSuperUsers(java.lang.String... items) {
    if (this.superUsers == null) return (A)this;
    for (String item : items) { this.superUsers.remove(item);} return (A)this;
  }
  
  public A removeAllFromSuperUsers(Collection<String> items) {
    if (this.superUsers == null) return (A)this;
    for (String item : items) { this.superUsers.remove(item);} return (A)this;
  }
  
  public List<String> getSuperUsers() {
    return this.superUsers;
  }
  
  public String getSuperUser(int index) {
    return this.superUsers.get(index);
  }
  
  public String getFirstSuperUser() {
    return this.superUsers.get(0);
  }
  
  public String getLastSuperUser() {
    return this.superUsers.get(superUsers.size() - 1);
  }
  
  public String getMatchingSuperUser(Predicate<String> predicate) {
      for (String item : superUsers) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSuperUser(Predicate<String> predicate) {
      for (String item : superUsers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSuperUsers(List<String> superUsers) {
    if (superUsers != null) {
        this.superUsers = new ArrayList();
        for (String item : superUsers) {
          this.addToSuperUsers(item);
        }
    } else {
      this.superUsers = null;
    }
    return (A) this;
  }
  
  public A withSuperUsers(java.lang.String... superUsers) {
    if (this.superUsers != null) {
        this.superUsers.clear();
        _visitables.remove("superUsers");
    }
    if (superUsers != null) {
      for (String item : superUsers) {
        this.addToSuperUsers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSuperUsers() {
    return this.superUsers != null && !this.superUsers.isEmpty();
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public boolean isAllowOnError() {
    return this.allowOnError;
  }
  
  public A withAllowOnError(boolean allowOnError) {
    this.allowOnError = allowOnError;
    return (A) this;
  }
  
  public boolean hasAllowOnError() {
    return true;
  }
  
  public int getInitialCacheCapacity() {
    return this.initialCacheCapacity;
  }
  
  public A withInitialCacheCapacity(int initialCacheCapacity) {
    this.initialCacheCapacity = initialCacheCapacity;
    return (A) this;
  }
  
  public boolean hasInitialCacheCapacity() {
    return true;
  }
  
  public int getMaximumCacheSize() {
    return this.maximumCacheSize;
  }
  
  public A withMaximumCacheSize(int maximumCacheSize) {
    this.maximumCacheSize = maximumCacheSize;
    return (A) this;
  }
  
  public boolean hasMaximumCacheSize() {
    return true;
  }
  
  public long getExpireAfterMs() {
    return this.expireAfterMs;
  }
  
  public A withExpireAfterMs(long expireAfterMs) {
    this.expireAfterMs = expireAfterMs;
    return (A) this;
  }
  
  public boolean hasExpireAfterMs() {
    return true;
  }
  
  public boolean isEnableMetrics() {
    return this.enableMetrics;
  }
  
  public A withEnableMetrics(boolean enableMetrics) {
    this.enableMetrics = enableMetrics;
    return (A) this;
  }
  
  public boolean hasEnableMetrics() {
    return true;
  }
  
  public A addToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").add(index, builder); tlsTrustedCertificates.add(index, builder);}
    return (A)this;
  }
  
  public A setToTlsTrustedCertificates(int index,CertSecretSource item) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
    if (index < 0 || index >= tlsTrustedCertificates.size()) { _visitables.get("tlsTrustedCertificates").add(builder); tlsTrustedCertificates.add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder); tlsTrustedCertificates.set(index, builder);}
    return (A)this;
  }
  
  public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  
  public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
  }
  
  public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
    if (this.tlsTrustedCertificates == null) return (A)this;
    for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder); this.tlsTrustedCertificates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
    if (tlsTrustedCertificates == null) return (A) this;
    final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
    final List visitables = _visitables.get("tlsTrustedCertificates");
    while (each.hasNext()) {
      CertSecretSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CertSecretSource> buildTlsTrustedCertificates() {
    return this.tlsTrustedCertificates != null ? build(tlsTrustedCertificates) : null;
  }
  
  public CertSecretSource buildTlsTrustedCertificate(int index) {
    return this.tlsTrustedCertificates.get(index).build();
  }
  
  public CertSecretSource buildFirstTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(0).build();
  }
  
  public CertSecretSource buildLastTlsTrustedCertificate() {
    return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
  }
  
  public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
      for (CertSecretSourceBuilder item : tlsTrustedCertificates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
      for (CertSecretSourceBuilder item : tlsTrustedCertificates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) {
      this._visitables.get("tlsTrustedCertificates").clear();
    }
    if (tlsTrustedCertificates != null) {
        this.tlsTrustedCertificates = new ArrayList();
        for (CertSecretSource item : tlsTrustedCertificates) {
          this.addToTlsTrustedCertificates(item);
        }
    } else {
      this.tlsTrustedCertificates = null;
    }
    return (A) this;
  }
  
  public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.common.CertSecretSource... tlsTrustedCertificates) {
    if (this.tlsTrustedCertificates != null) {
        this.tlsTrustedCertificates.clear();
        _visitables.remove("tlsTrustedCertificates");
    }
    if (tlsTrustedCertificates != null) {
      for (CertSecretSource item : tlsTrustedCertificates) {
        this.addToTlsTrustedCertificates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTlsTrustedCertificates() {
    return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
  }
  
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
    return new TlsTrustedCertificatesNested(-1, null);
  }
  
  public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
    return new TlsTrustedCertificatesNested(-1, item);
  }
  
  public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item) {
    return new TlsTrustedCertificatesNested(index, item);
  }
  
  public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
    if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  
  public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
    if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
  }
  
  public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
    int index = tlsTrustedCertificates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  
  public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tlsTrustedCertificates.size();i++) { 
    if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
    return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KafkaAuthorizationOpaFluent that = (KafkaAuthorizationOpaFluent) o;
    if (!java.util.Objects.equals(superUsers, that.superUsers)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (allowOnError != that.allowOnError) return false;
    if (initialCacheCapacity != that.initialCacheCapacity) return false;
    if (maximumCacheSize != that.maximumCacheSize) return false;
    if (expireAfterMs != that.expireAfterMs) return false;
    if (enableMetrics != that.enableMetrics) return false;
    if (!java.util.Objects.equals(tlsTrustedCertificates, that.tlsTrustedCertificates)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(superUsers,  url,  allowOnError,  initialCacheCapacity,  maximumCacheSize,  expireAfterMs,  enableMetrics,  tlsTrustedCertificates,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (superUsers != null && !superUsers.isEmpty()) { sb.append("superUsers:"); sb.append(superUsers + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    sb.append("allowOnError:"); sb.append(allowOnError + ",");
    sb.append("initialCacheCapacity:"); sb.append(initialCacheCapacity + ",");
    sb.append("maximumCacheSize:"); sb.append(maximumCacheSize + ",");
    sb.append("expireAfterMs:"); sb.append(expireAfterMs + ",");
    sb.append("enableMetrics:"); sb.append(enableMetrics + ",");
    if (tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty()) { sb.append("tlsTrustedCertificates:"); sb.append(tlsTrustedCertificates); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllowOnError() {
    return withAllowOnError(true);
  }
  
  public A withEnableMetrics() {
    return withEnableMetrics(true);
  }
  public class TlsTrustedCertificatesNested<N> extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>> implements Nested<N>{
    TlsTrustedCertificatesNested(int index,CertSecretSource item) {
      this.index = index;
      this.builder = new CertSecretSourceBuilder(this, item);
    }
    CertSecretSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) KafkaAuthorizationOpaFluent.this.setToTlsTrustedCertificates(index,builder.build());
    }
    
    public N endTlsTrustedCertificate() {
      return and();
    }
    
  
  }

}