package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaAuthorizationOpaBuilder extends KafkaAuthorizationOpaFluent<KafkaAuthorizationOpaBuilder> implements VisitableBuilder<KafkaAuthorizationOpa,KafkaAuthorizationOpaBuilder>{
  public KafkaAuthorizationOpaBuilder() {
    this(new KafkaAuthorizationOpa());
  }
  
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent) {
    this(fluent, new KafkaAuthorizationOpa());
  }
  
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,KafkaAuthorizationOpa instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpa instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaAuthorizationOpaFluent<?> fluent;
  
  public KafkaAuthorizationOpa build() {
    KafkaAuthorizationOpa buildable = new KafkaAuthorizationOpa();
    buildable.setSuperUsers(fluent.getSuperUsers());
    buildable.setUrl(fluent.getUrl());
    buildable.setAllowOnError(fluent.isAllowOnError());
    buildable.setInitialCacheCapacity(fluent.getInitialCacheCapacity());
    buildable.setMaximumCacheSize(fluent.getMaximumCacheSize());
    buildable.setExpireAfterMs(fluent.getExpireAfterMs());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    return buildable;
  }
  

}