package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaAuthorizationKeycloakBuilder extends KafkaAuthorizationKeycloakFluent<KafkaAuthorizationKeycloakBuilder> implements VisitableBuilder<KafkaAuthorizationKeycloak,KafkaAuthorizationKeycloakBuilder>{
  public KafkaAuthorizationKeycloakBuilder() {
    this(new KafkaAuthorizationKeycloak());
  }
  
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent) {
    this(fluent, new KafkaAuthorizationKeycloak());
  }
  
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloakFluent<?> fluent,KafkaAuthorizationKeycloak instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaAuthorizationKeycloakBuilder(KafkaAuthorizationKeycloak instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaAuthorizationKeycloakFluent<?> fluent;
  
  public KafkaAuthorizationKeycloak build() {
    KafkaAuthorizationKeycloak buildable = new KafkaAuthorizationKeycloak();
    buildable.setClientId(fluent.getClientId());
    buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
    buildable.setTlsTrustedCertificates(fluent.buildTlsTrustedCertificates());
    buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
    buildable.setDelegateToKafkaAcls(fluent.isDelegateToKafkaAcls());
    buildable.setGrantsRefreshPeriodSeconds(fluent.getGrantsRefreshPeriodSeconds());
    buildable.setGrantsRefreshPoolSize(fluent.getGrantsRefreshPoolSize());
    buildable.setGrantsMaxIdleTimeSeconds(fluent.getGrantsMaxIdleTimeSeconds());
    buildable.setGrantsGcPeriodSeconds(fluent.getGrantsGcPeriodSeconds());
    buildable.setGrantsAlwaysLatest(fluent.isGrantsAlwaysLatest());
    buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
    buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
    buildable.setHttpRetries(fluent.getHttpRetries());
    buildable.setSuperUsers(fluent.getSuperUsers());
    buildable.setEnableMetrics(fluent.isEnableMetrics());
    buildable.setIncludeAcceptHeader(fluent.isIncludeAcceptHeader());
    return buildable;
  }
  

}