package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaAuthorizationCustomBuilder extends KafkaAuthorizationCustomFluent<KafkaAuthorizationCustomBuilder> implements VisitableBuilder<KafkaAuthorizationCustom,KafkaAuthorizationCustomBuilder>{
  public KafkaAuthorizationCustomBuilder() {
    this(new KafkaAuthorizationCustom());
  }
  
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent) {
    this(fluent, new KafkaAuthorizationCustom());
  }
  
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,KafkaAuthorizationCustom instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaAuthorizationCustomFluent<?> fluent;
  
  public KafkaAuthorizationCustom build() {
    KafkaAuthorizationCustom buildable = new KafkaAuthorizationCustom();
    buildable.setAuthorizerClass(fluent.getAuthorizerClass());
    buildable.setSuperUsers(fluent.getSuperUsers());
    buildable.setSupportsAdminApi(fluent.isSupportsAdminApi());
    return buildable;
  }
  

}