package io.strimzi.api.kafka.model.kafka;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EphemeralStorageBuilder extends EphemeralStorageFluent<EphemeralStorageBuilder> implements VisitableBuilder<EphemeralStorage,EphemeralStorageBuilder>{
  public EphemeralStorageBuilder() {
    this(new EphemeralStorage());
  }
  
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent) {
    this(fluent, new EphemeralStorage());
  }
  
  public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EphemeralStorageBuilder(EphemeralStorage instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EphemeralStorageFluent<?> fluent;
  
  public EphemeralStorage build() {
    EphemeralStorage buildable = new EphemeralStorage();
    buildable.setSizeLimit(fluent.getSizeLimit());
    buildable.setId(fluent.getId());
    buildable.setKraftMetadata(fluent.getKraftMetadata());
    return buildable;
  }
  

}