package io.strimzi.api.kafka.model.jmxtrans;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxTransSpecBuilder extends JmxTransSpecFluent<JmxTransSpecBuilder> implements VisitableBuilder<JmxTransSpec,JmxTransSpecBuilder>{
  public JmxTransSpecBuilder() {
    this(new JmxTransSpec());
  }
  
  public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent) {
    this(fluent, new JmxTransSpec());
  }
  
  public JmxTransSpecBuilder(JmxTransSpecFluent<?> fluent,JmxTransSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxTransSpecBuilder(JmxTransSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxTransSpecFluent<?> fluent;
  
  public JmxTransSpec build() {
    JmxTransSpec buildable = new JmxTransSpec();
    buildable.setImage(fluent.getImage());
    buildable.setLogLevel(fluent.getLogLevel());
    buildable.setOutputDefinitions(fluent.buildOutputDefinitions());
    buildable.setKafkaQueries(fluent.buildKafkaQueries());
    buildable.setResources(fluent.getResources());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}