package io.strimzi.api.kafka.model.jmxtrans;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxTransQueryTemplateBuilder extends JmxTransQueryTemplateFluent<JmxTransQueryTemplateBuilder> implements VisitableBuilder<JmxTransQueryTemplate,JmxTransQueryTemplateBuilder>{
  public JmxTransQueryTemplateBuilder() {
    this(new JmxTransQueryTemplate());
  }
  
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent) {
    this(fluent, new JmxTransQueryTemplate());
  }
  
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplateFluent<?> fluent,JmxTransQueryTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxTransQueryTemplateBuilder(JmxTransQueryTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxTransQueryTemplateFluent<?> fluent;
  
  public JmxTransQueryTemplate build() {
    JmxTransQueryTemplate buildable = new JmxTransQueryTemplate();
    buildable.setTargetMBean(fluent.getTargetMBean());
    buildable.setAttributes(fluent.getAttributes());
    buildable.setOutputs(fluent.getOutputs());
    return buildable;
  }
  

}