package io.strimzi.api.kafka.model.jmxtrans;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JmxTransOutputDefinitionTemplateBuilder extends JmxTransOutputDefinitionTemplateFluent<JmxTransOutputDefinitionTemplateBuilder> implements VisitableBuilder<JmxTransOutputDefinitionTemplate,JmxTransOutputDefinitionTemplateBuilder>{
  public JmxTransOutputDefinitionTemplateBuilder() {
    this(new JmxTransOutputDefinitionTemplate());
  }
  
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent) {
    this(fluent, new JmxTransOutputDefinitionTemplate());
  }
  
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,JmxTransOutputDefinitionTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JmxTransOutputDefinitionTemplateFluent<?> fluent;
  
  public JmxTransOutputDefinitionTemplate build() {
    JmxTransOutputDefinitionTemplate buildable = new JmxTransOutputDefinitionTemplate();
    buildable.setOutputType(fluent.getOutputType());
    buildable.setHost(fluent.getHost());
    buildable.setPort(fluent.getPort());
    buildable.setFlushDelayInSeconds(fluent.getFlushDelayInSeconds());
    buildable.setName(fluent.getName());
    buildable.setTypeNames(fluent.getTypeNames());
    return buildable;
  }
  

}