package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ListOffsetsBuilder extends ListOffsetsFluent<ListOffsetsBuilder> implements VisitableBuilder<ListOffsets,ListOffsetsBuilder>{
  public ListOffsetsBuilder() {
    this(new ListOffsets());
  }
  
  public ListOffsetsBuilder(ListOffsetsFluent<?> fluent) {
    this(fluent, new ListOffsets());
  }
  
  public ListOffsetsBuilder(ListOffsetsFluent<?> fluent,ListOffsets instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ListOffsetsBuilder(ListOffsets instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ListOffsetsFluent<?> fluent;
  
  public ListOffsets build() {
    ListOffsets buildable = new ListOffsets();
    buildable.setToConfigMap(fluent.getToConfigMap());
    return buildable;
  }
  

}