package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaConnectorStatusBuilder extends KafkaConnectorStatusFluent<KafkaConnectorStatusBuilder> implements VisitableBuilder<KafkaConnectorStatus,KafkaConnectorStatusBuilder>{
  public KafkaConnectorStatusBuilder() {
    this(new KafkaConnectorStatus());
  }
  
  public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent) {
    this(fluent, new KafkaConnectorStatus());
  }
  
  public KafkaConnectorStatusBuilder(KafkaConnectorStatusFluent<?> fluent,KafkaConnectorStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaConnectorStatusBuilder(KafkaConnectorStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaConnectorStatusFluent<?> fluent;
  
  public KafkaConnectorStatus build() {
    KafkaConnectorStatus buildable = new KafkaConnectorStatus();
    buildable.setConnectorStatus(fluent.getConnectorStatus());
    buildable.setTasksMax(fluent.getTasksMax());
    buildable.setTopics(fluent.getTopics());
    buildable.setAutoRestart(fluent.buildAutoRestart());
    buildable.setConditions(fluent.buildConditions());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    return buildable;
  }
  

}