package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaConnectorSpecBuilder extends KafkaConnectorSpecFluent<KafkaConnectorSpecBuilder> implements VisitableBuilder<KafkaConnectorSpec,KafkaConnectorSpecBuilder>{
  public KafkaConnectorSpecBuilder() {
    this(new KafkaConnectorSpec());
  }
  
  public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent) {
    this(fluent, new KafkaConnectorSpec());
  }
  
  public KafkaConnectorSpecBuilder(KafkaConnectorSpecFluent<?> fluent,KafkaConnectorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaConnectorSpecBuilder(KafkaConnectorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaConnectorSpecFluent<?> fluent;
  
  public KafkaConnectorSpec build() {
    KafkaConnectorSpec buildable = new KafkaConnectorSpec();
    buildable.setClassName(fluent.getClassName());
    buildable.setTasksMax(fluent.getTasksMax());
    buildable.setPause(fluent.getPause());
    buildable.setConfig(fluent.getConfig());
    buildable.setState(fluent.getState());
    buildable.setAutoRestart(fluent.buildAutoRestart());
    buildable.setListOffsets(fluent.buildListOffsets());
    buildable.setAlterOffsets(fluent.buildAlterOffsets());
    return buildable;
  }
  

}